<?php
/**
 * 2007-2015 PrestaShop
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License (AFL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/afl-3.0.php
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade PrestaShop to newer
 * versions in the future. If you wish to customize PrestaShop for your
 * needs please refer to http://www.prestashop.com for more information.
 *
 *  @author PrestaShop SA <contact@prestashop.com>
 *  @copyright  2007-2015 PrestaShop SA
 *  @license    http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
 *  International Registered Trademark & Property of PrestaShop SA
 */

require_once(_PS_MODULE_DIR_ . 'mensagiaprestashop/classes/MensagiaSDK.php');
require_once(_PS_MODULE_DIR_ . 'mensagiaprestashop/mensagiaprestashop.php');
require_once(_PS_CLASS_DIR_ . 'controller/ModuleAdminController.php');

class MensagiaPrestashopExport
{
    private $exporting;
    private $prefix_agenda;
    private $delete_agendas;
    private $blacklist_with_newsletter;
    private $blacklists = [];
    private $limit;
    private $jobs;
    private $jobs_done;
    private $next_index_group_to_export;
    private $export_started;
    private $processes;
    private $contact_fields;
    private $extrafields;
    private $default_language_id;
    private $date_format_lite;
    private $date_format_full;
    private $waiting_finish_processes;
    private $finished;
    private $processes_checked_errors;
    private $prefix_mode;
    private $total_rows_processed;
    private $total_created_contacts;
    private $total_imported_contacts;
    private $total_errors;
    private $priority_field;
    private $mensagiaSDK;

    private $icon_separator;

    public function __construct($options)
    {
        $options = json_decode($options, true);

        $this->exporting                  = $options['exporting'];
        $this->prefix_agenda              = $options['prefix_agenda'];
        $this->delete_agendas             = $options['delete_agendas'];
        $this->blacklist_with_newsletter  = $options['blacklist_with_newsletter'];
        $this->blacklists                 = $options['blacklists'];
        $this->limit                      = $options['limit'];
        $this->jobs                       = $options['jobs'];
        $this->jobs_done                  = $options['jobs_done'];
        $this->groups                     = $options['groups'];
        $this->next_index_group_to_export = $options['next_index_group_to_export'];
        $this->export_started             = $options['export_started'];
        $this->contact_fields             = $options['contact_fields'];
        $this->processes                  = $options['processes'];
        $this->extrafields                = $options['extrafields'];
        $this->default_language_id        = $options['default_language_id'];
        $this->date_format_lite           = $options['date_format_lite'];
        $this->date_format_full           = $options['date_format_full'];
        $this->waiting_finish_processes   = $options['waiting_finish_processes'];
        $this->finished                   = $options['finished'];
        $this->processes_checked_errors   = $options['processes_checked_errors'];
        $this->prefix_mode                = $options['prefix_mode'];
        $this->total_rows_processed       = $options['total_rows_processed'];
        $this->total_created_contacts     = $options['total_created_contacts'];
        $this->total_imported_contacts    = $options['total_imported_contacts'];
        $this->total_errors               = $options['total_errors'];
        $this->priority_field             = $options['priority_field'];

        $this->mensagiaSDK        = new MensagiaSDK();
        $this->mensagiaPrestashop = new mensagiaprestashop();
        $this->mensagiaSDK->authenticate(
            Configuration::get('MENSAGIA_LOGIN_EMAIL'),
            Configuration::get('MENSAGIA_LOGIN_PASSWORD')
        );

        $this->icon_separator = "<i class='icon-angle-double-right' aria-hidden='true'></i>";
    }

    public function exportFinished()
    {
        $html       = "";
        $errors     = "";

        $html .= "<span style='font-weight:bold;font-size:14px;display:block;margin-top:15px;".
            "text-decoration: underline;margin-bottom:5px;'>".
            $this->mensagiaPrestashop->l('Import completed')."</span>";
        $html .= $this->icon_separator." ".$this->mensagiaPrestashop->l('Total contacts processed').": ".
            $this->total_rows_processed.". <br>";
        $html .= $this->icon_separator." ".$this->mensagiaPrestashop->l('Total contacts created').": ".
            $this->total_created_contacts.". <br>";
        $html .= $this->icon_separator." ".$this->mensagiaPrestashop->l('Total contacts imported').": ".
            $this->total_imported_contacts.". <br>";
        $html .= $this->icon_separator." ".$this->mensagiaPrestashop->l('Total errors').": ".
            $this->total_errors.".<br>";

        return json_encode(array(
            'html'      => $html,
            'options'   => get_object_vars($this),
            'errors'    => $errors,
        ));
    }

    public function waitingFinishProcesses()
    {
        $html       = "";
        $errors     = "";
        $continue   = true;

        $count_processes = count($this->processes);
        $count_processes_checked = count($this->processes_checked_errors);

        $counters               = array();

        $counters['finished']   = 0;
        $counters['error']      = 0;
        $counters['waiting']    = 0;

        if ($count_processes &&  $count_processes_checked < $count_processes) {
            $processes_list = implode(',', $this->processes);

            if (!$this->waiting_finish_processes) {
                $html .= "<span style='font-weight:bold;font-size:14px;display:block;margin-top:15px;".
                    "text-decoration: underline;margin-bottom:5px;'>".
                    $this->mensagiaPrestashop->l('Import groups to Mensagia')."</span>";
                $this->waiting_finish_processes = true;
            }

            $processes = $this->mensagiaSDK->getProcesses($processes_list, 'ContactsMassiveJson');

            if (isset($processes['data'])) {
                foreach ($processes['data'] as $process) {
                    if ($process['state'] == 'finished') {
                        if (!in_array($process['id'], $this->processes_checked_errors)) {
                            // Buscamos el resumen
                            $summary = $this->mensagiaSDK->getSummaryImport($process['id']);

                            if (isset($summary['data'])) {
                                $html .= " ".$this->icon_separator." ".
                                    $this->mensagiaPrestashop->l('Request processed correctly. ');
                                $html .= $this->mensagiaPrestashop->l('Processed contacts').": ".
                                    $summary['data']['total_rows_processed'].". ";
                                $html .= $this->mensagiaPrestashop->l('Created contacts').": ".
                                    $summary['data']['total_created'].". ";
                                $html .= $this->mensagiaPrestashop->l('Imported contacts').": ".
                                    $summary['data']['total_imported'].". ";
                                $html .= $this->mensagiaPrestashop->l('Errors').": ".
                                    $summary['data']['total_errors'].".<br>";

                                // actualizamos contadores
                                $this->total_rows_processed       =
                                    $this->total_rows_processed + $summary['data']['total_rows_processed'];
                                $this->total_created_contacts     =
                                    $this->total_created_contacts + $summary['data']['total_created'];
                                $this->total_imported_contacts    =
                                    $this->total_imported_contacts + $summary['data']['total_imported'];
                                $this->total_errors               =
                                    $this->total_errors + $summary['data']['total_errors'];

                                $counters['finished']++;
                                array_push($this->processes_checked_errors, $process['id']);
                            }

                            // buscamos los errores

                            $import_errors = $this->mensagiaSDK->getImportErrors($process['id']);

                            if (isset($import_errors['data'])) {
                                foreach ($import_errors['data'] as $errorList) {
                                    $errors .= $this->icon_separator." <b>[".$errorList['error_code']."]</b> Name: ".
                                        $errorList['json_user_object']['contact']['name'] .
                                        " (".$errorList['json_user_object']['contact']['email']."). 
                                        Phone Mobile: ".$errorList['json_user_object']['contact']['number']."<br>";
                                }
                            }
                        }
                    } elseif ($process['state'] == 'error') {
                        $counters['error']++;
                        array_push($this->processes_checked_errors, $process['id']);

                        $errors.= $this->mensagiaPrestashop
                            ->l('There was an error importing in Mensagia.');
                        $continue = false;
                    } else {
                        $counters['waiting']++;
                    }
                }

                $total_processes_done = $counters['finished'] + $counters['error'];
                $count_processes_checked = count($this->processes_checked_errors);

                if ($total_processes_done == $count_processes and $total_processes_done != 0) {
                    $this->finished = true;
                    $this->jobs_done++;
                    $html .= $this->icon_separator." ".
                        $this->mensagiaPrestashop->l('Import finished. Completed requests: ')." ".
                        $count_processes_checked."/".$count_processes."<br>";
                } else {
                    $html .= $this->icon_separator." ".
                        $this->mensagiaPrestashop->l('Waiting responses from Mensagia. '.
                            'Completed requests: ')." ".
                        $count_processes_checked."/".$count_processes."<br>";
                }
            } else {
                $errors.= $this->mensagiaPrestashop
                    ->l('There was an unexpected error checking the processes in Mensagia.');
                $continue = false;
            }
        } else {
            $this->finished = true;
            $this->jobs_done++;
        }

        return json_encode(array(
            'html'      => $html,
            'options'   => get_object_vars($this),
            'errors'    => $errors,
            'continue'  => $continue,
        ));
    }

    public function exportGroups()
    {
        $count_groups = count($this->groups);

        $html   = "";
        $errors = "";

        if (!$this->export_started) {
            $html .= "<span style='font-weight:bold;font-size:14px;display:block;margin-top:15px;".
                "text-decoration: underline;margin-bottom:5px;'>".
                $this->mensagiaPrestashop->l('Import requests to Mensagia')."</span>";
            $this->export_started = true;
        }

        if ($this->next_index_group_to_export !== null) {
            if ($this->groups[$this->next_index_group_to_export]['jobs']) {
                if (! $this->groups[$this->next_index_group_to_export]['export_started']) {
                    $html .= "<b>".$this->mensagiaPrestashop->l('Users import requests to the agenda: ').
                        $this->groups[$this->next_index_group_to_export]['agenda_name_mensagia']."</b><br>";
                    $this->groups[$this->next_index_group_to_export]['export_started'] = true;
                }

                $html .= $this->icon_separator." ".
                    $this->mensagiaPrestashop->l('Request successfully made. Request number ').
                    ($this->groups[$this->next_index_group_to_export]['jobs_done'] + 1).".<br>";

                // exportamos los usuarios
                $errors_exports = $this->processExportUsers(
                    $this->groups[$this->next_index_group_to_export],
                    $this->next_index_group_to_export
                );

                // controlamos los errores de sin número de movil antes de exportar al usuario
                if (count($errors_exports['no_phone_mobile'])) {
                    foreach ($errors_exports['no_phone_mobile'] as $errorList) {
                        $errors .= $this->icon_separator." <b>[WITHOUT_NUMBER]</b> Name: ".$errorList['firstname']." ".
                            $errorList['lastname']." (".$errorList['email'].")<br>";
                        $this->total_rows_processed++;
                        $this->total_errors++;
                    }
                }

                // controlamos los errores de no address antes de exportar al usuario
                if (count($errors_exports['no_address'])) {
                    foreach ($errors_exports['no_address'] as $errorList) {
                        $errors .= $this->icon_separator." <b>[WITHOUT_ADDRESS]</b> Name: ".$errorList['firstname']." ".
                            $errorList['lastname']." (".$errorList['email'].")<br>";
                        $this->total_rows_processed++;
                        $this->total_errors++;
                    }
                }

                // Actualizamos contadores de trabajos
                $this->groups[(int) $this->next_index_group_to_export]['jobs_done']++;
                $this->jobs_done++;

                // miramos si ha hecho todos los trabajos para este grupo
                $actual_jobs_done = (int) $this->groups[$this->next_index_group_to_export]['jobs_done'];

                if ($actual_jobs_done == (int) $this->groups[$this->next_index_group_to_export]['jobs']) {
                    if ((int) $this->next_index_group_to_export + 1 < (int) $count_groups) {
                        $this->next_index_group_to_export++;
                    } else {
                        $this->next_index_group_to_export = null;

                        $html .= "<b>".$this->mensagiaPrestashop
                                ->l('Import requests from groups to Mensagia finished')."</b><br>";
                        $html .= $this->icon_separator." ".
                            $this->mensagiaPrestashop
                                ->l('Import request from groups to Mensagia finished')."<br>";
                    }
                }
            } else {
                if ((int) $this->next_index_group_to_export + 1 < (int) $count_groups) {
                    $this->next_index_group_to_export++;
                } else {
                    $this->next_index_group_to_export = null;

                    $html .= "<b>".$this->mensagiaPrestashop
                            ->l('Import request from groups to Mensagia finished')."</b><br>";

                    $html .= $this->icon_separator." ".
                        $this->mensagiaPrestashop
                            ->l('Import requests to Mensagia have completed successfully.')."<br>";
                }
            }
        } else {
            $html .= $this->icon_separator." ".$this->mensagiaPrestashop
                    ->l('Groups to export do not have valid users.');
        }

        $continue = true;

        return json_encode(array(
            'html'      => $html,
            'options'   => get_object_vars($this),
            'errors'    => $errors,
            'continue'  => $continue,
        ));
    }

    private function getCustomerLastOrderDate($id_customer)
    {
        $query = "SELECT date_add
                    FROM `"._DB_PREFIX_."orders`
                    WHERE id_customer = ".$id_customer."
                    AND valid = 1
                    ORDER BY date_add DESC
                    LIMIT 1";


        $result = Db::getInstance(_PS_USE_SQL_SLAVE_)->executeS($query);

        if (isset($result[0]['date_add'])) {
            if ($result[0]['date_add']) {
                return $result[0]['date_add'];
            } else {
                return null;
            }
        }

        return null;
    }

    private function setFormatToDate($valueExtrafield, $extrafield)
    {
        if ($valueExtrafield != '0000-00-00' and $valueExtrafield != '0000-00-00 00:00:00'
            and $valueExtrafield != null and $valueExtrafield != '') {
            if ($extrafield['date_format_type'] == 'date_format_lite') {
                $date_format = $this->date_format_lite;
            } else {
                $date_format = $this->date_format_full;
            }

            $date = new DateTime($valueExtrafield);
            return $date->format($date_format);
        }

        return null;
    }


    private function getCustomerSpent($id_customer)
    {
        $query = "SELECT sum(total_paid) as total_paid
                    FROM `"._DB_PREFIX_."orders`
                    WHERE id_customer = ".$id_customer."
                    AND valid = 1";

        $result = Db::getInstance(_PS_USE_SQL_SLAVE_)->executeS($query);

        if (isset($result[0]['total_paid'])) {
            if ($result[0]['total_paid']) {
                return number_format(
                    $result[0]['total_paid'],
                    2,
                    '.',
                    ''
                );
            } else {
                return 0;
            }
        }

        return 0;
    }

    private function getCustomerSpentCurrentYear($id_customer)
    {
        $query = "SELECT sum(total_paid) as total_paid
                    FROM `"._DB_PREFIX_."orders`
                    WHERE id_customer = ".$id_customer."
                    AND valid = 1
                    AND YEAR(date_add) = YEAR(CURDATE());";

        $result = Db::getInstance(_PS_USE_SQL_SLAVE_)->executeS($query);

        if (isset($result[0]['total_paid'])) {
            if ($result[0]['total_paid']) {
                return number_format(
                    $result[0]['total_paid'],
                    2,
                    '.',
                    ''
                );
            } else {
                return 0;
            }
        }

        return 0;
    }



    private function getCustomerSpentLastYear($id_customer)
    {
        $query = "SELECT sum(total_paid) as total_paid
                    FROM `"._DB_PREFIX_."orders`
                    WHERE id_customer = ".$id_customer."
                    AND valid = 1
                    AND YEAR(date_add) = ( YEAR(CURDATE()) - 1);";

        $result = Db::getInstance(_PS_USE_SQL_SLAVE_)->executeS($query);

        if (isset($result[0]['total_paid'])) {
            if ($result[0]['total_paid']) {
                return number_format(
                    $result[0]['total_paid'],
                    2,
                    '.',
                    ''
                );
            } else {
                return 0;
            }
        }

        return 0;
    }

    private function getCustomerSpentCurrentMonth($id_customer)
    {
        $query = "SELECT sum(total_paid) as total_paid
                    FROM `"._DB_PREFIX_."orders`
                    WHERE id_customer = ".$id_customer."
                    AND valid = 1
                    AND MONTH(date_add) = MONTH(CURDATE());";

        $result = Db::getInstance(_PS_USE_SQL_SLAVE_)->executeS($query);

        if (isset($result[0]['total_paid'])) {
            if ($result[0]['total_paid']) {
                return number_format(
                    $result[0]['total_paid'],
                    2,
                    '.',
                    ''
                );
            } else {
                return 0;
            }
        }

        return 0;
    }



    private function getCustomerSpentLastMonth($id_customer)
    {
        $query = "SELECT sum(total_paid) as total_paid
                    FROM `"._DB_PREFIX_."orders`
                    WHERE id_customer = ".$id_customer."
                    AND valid = 1
                    AND MONTH(date_add) = ( MONTH(CURDATE() - INTERVAL 1 MONTH) );";

        $result = Db::getInstance(_PS_USE_SQL_SLAVE_)->executeS($query);

        if (isset($result[0]['total_paid'])) {
            if ($result[0]['total_paid']) {
                return number_format(
                    $result[0]['total_paid'],
                    2,
                    '.',
                    ''
                );
            } else {
                return 0;
            }
        }

        return 0;
    }

    private function getCustomerCartForgottenLastDate($id_customer)
    {
        $query = "SELECT date_add
                    FROM `"._DB_PREFIX_."cart`
                    WHERE id_customer = ".$id_customer."
                    ORDER BY date_add DESC
                    LIMIT 1";


        $result = Db::getInstance(_PS_USE_SQL_SLAVE_)->executeS($query);

        if (isset($result[0]['date_add'])) {
            if ($result[0]['date_add']) {
                return $result[0]['date_add'];
            } else {
                return null;
            }
        }

        return null;
    }

    private function getCustomerDateCartSinceLastPurchase($id_customer)
    {
        $last_purchase = $this->getCustomerLastOrderDate($id_customer);

        if ($last_purchase) {
            $query_add = " AND date_add > '$last_purchase' ";
        } else {
            $query_add = "";
        }

        $query = "SELECT count(*) as count
                    FROM `"._DB_PREFIX_."cart`
                    WHERE id_customer = ".$id_customer.".$query_add";

        $result = Db::getInstance(_PS_USE_SQL_SLAVE_)->executeS($query);

        if (isset($result[0]['count'])) {
            if ($result[0]['count']) {
                return $result[0]['count'];
            } else {
                return 0;
            }
        }

        return 0;
    }

    private function getCustomerNumberOrdersValids($id_customer)
    {
        $query = "SELECT count(*) as count
                    FROM `"._DB_PREFIX_."orders`
                    WHERE id_customer = ".$id_customer."
                    AND valid = 1";


        $result = Db::getInstance(_PS_USE_SQL_SLAVE_)->executeS($query);

        if (isset($result[0]['count'])) {
            if ($result[0]['count']) {
                return $result[0]['count'];
            } else {
                return 0;
            }
        }

        return 0;
    }

    private function getCustomerLastVisit($id_customer)
    {
        $query = "SELECT con.date_add as last_visit
                    FROM `"._DB_PREFIX_."connections` as con
                    LEFT JOIN `"._DB_PREFIX_."guest` as guest ON con.id_guest = guest.id_guest
                    WHERE guest.id_customer = ".$id_customer."
                    ORDER BY con.date_add DESC
                    LIMIT 1;";

        $result = Db::getInstance(_PS_USE_SQL_SLAVE_)->executeS($query);

        if (isset($result[0]['last_visit'])) {
            if ($result[0]['last_visit']) {
                return $result[0]['last_visit'];
            } else {
                return null;
            }
        }

        return null;
    }

    /**
     * @param $group
     * @param $actual_index_group
     */
    private function processExportUsers($group, $actual_index_group)
    {
        $query = ' SELECT * 
                    FROM `'._DB_PREFIX_.'customer` 
                    WHERE active = 1 
                    AND id_default_group = '.$group['group_id'].' 
                    LIMIT '.$this->limit.' 
                    OFFSET '.$this->limit * $group['jobs_done'].' ;';

        $result = Db::getInstance(_PS_USE_SQL_SLAVE_)->executeS($query);

        $no_phone_mobile    = array();
        $no_address         = array();
        $valids             = array();
        $phone_mobile       = null;
        $state_name         = null;
        $country_name       = null;

        if ($result) {
            foreach ($result as $user) {
                // Get the customer phone mobile from the first customer Address
                $address_id = Address::getFirstCustomerAddressId($user['id_customer']);

                if ($address_id) {
                    // Buscamos la dirección y el teléfono móvil
                    $address = new Address($address_id);

                    // Get country and state
                    $countryAndState = Address::getCountryAndState($address_id);
                    $state_name     = State::getNameById($countryAndState['id_state']);
                    $country_name   = Country::getNameById(Configuration::get('PS_LANG_DEFAULT'), $countryAndState['id_country']);

                    if ($address->phone_mobile) {
                        $phone_mobile =  $address->phone_mobile;

                        // limpiamos el número de caracteres extraños
                        $phone_mobile = $this->mensagiaSDK->cleanNumber($phone_mobile);

                        if ($this->prefix_mode == 'check_prefixs') {
                            // Buscamos el pais de la compra
                            $country_iso_code_address = Country::getIsoById($address->id_country);

                            // Buscamos el país en Mensagia
                            $mensagia_country = MensagiaCountry::getMensagiaCountryByISO($country_iso_code_address);

                            // comprobamos prefijo del número
                            $phone_mobile = $this->mensagiaSDK->checkAndSetPrefix(
                                $phone_mobile,
                                $mensagia_country['phone']
                            );
                        }
                    }
                }

                // comprobamos que tenga al menos un campo primario
                if ($phone_mobile or $user['email']) {
                    // buscamos los valores de los extrafields que nos han enviado
                    $extrafields_users = array();

                    foreach ($this->extrafields as $extrafield) {
                        if ($extrafield['ps_group'] == 'customer') {
                            $valueExtrafield = $user[str_replace(
                                'ps_',
                                '',
                                $extrafield['name']
                            )];

                            if ($extrafield['extra_field_type'] != 'date') {
                                if ($valueExtrafield === null) {
                                    $valueExtrafield = "";
                                }

                                $extrafields_users[$extrafield['name']] = $valueExtrafield;
                            } else {
                                if ($this->setFormatToDate($valueExtrafield, $extrafield)) {
                                    $extrafields_users[$extrafield['name']] = $this->setFormatToDate(
                                        $valueExtrafield,
                                        $extrafield
                                    );
                                }
                            }
                        } elseif ($extrafield['ps_group'] == 'order') {
                            switch ($extrafield['name']) {
                                case 'ps_date_last_order':
                                    $last_order_date = $this->getCustomerLastOrderDate($user['id_customer']);

                                    if ($last_order_date) {
                                        if ($this->setFormatToDate($last_order_date, $extrafield)) {
                                            $extrafields_users[$extrafield['name']] = $this->setFormatToDate(
                                                $last_order_date,
                                                $extrafield
                                            );
                                        }
                                    }

                                    break;

                                case 'ps_orders_quantity':
                                    $num_orders_valids = $this->getCustomerNumberOrdersValids(
                                        $user['id_customer']
                                    );
                                    $extrafields_users[$extrafield['name']] = $num_orders_valids;
                                    break;

                                case 'ps_orders_total_spent':
                                    $total_spent = $this->getCustomerSpent(
                                        $user['id_customer']
                                    );
                                    $extrafields_users[$extrafield['name']] = $total_spent;
                                    break;

                                case 'ps_orders_total_spent_current_year':
                                    $total_spent = $this->getCustomerSpentCurrentYear(
                                        $user['id_customer']
                                    );
                                    $extrafields_users[$extrafield['name']] = $total_spent;
                                    break;

                                case 'ps_orders_total_spent_last_year':
                                    $total_spent = $this->getCustomerSpentLastYear(
                                        $user['id_customer']
                                    );
                                    $extrafields_users[$extrafield['name']] = $total_spent;
                                    break;

                                case 'ps_orders_total_spent_current_month':
                                    $total_spent = $this->getCustomerSpentCurrentMonth(
                                        $user['id_customer']
                                    );
                                    $extrafields_users[$extrafield['name']] = $total_spent;
                                    break;

                                case 'ps_orders_total_spent_last_month':
                                    $total_spent = $this->getCustomerSpentLastMonth(
                                        $user['id_customer']
                                    );
                                    $extrafields_users[$extrafield['name']] = $total_spent;
                                    break;
                            }
                        } elseif ($extrafield['ps_group'] == 'connections') {
                            switch ($extrafield['name']) {
                                case 'ps_last_visit':
                                    $last_visit = $this->getCustomerLastVisit($user['id_customer']);

                                    if ($last_visit) {
                                        if ($this->setFormatToDate($last_visit, $extrafield)) {
                                            $extrafields_users[$extrafield['name']] = $this->setFormatToDate(
                                                $last_visit,
                                                $extrafield
                                            );
                                        }
                                    }

                                    break;
                            }
                        } elseif ($extrafield['ps_group'] == 'cart') {
                            switch ($extrafield['name']) {
                                case 'ps_cart_forgotten_last_date':
                                    $last_date_forgotten_cart = $this->getCustomerCartForgottenLastDate(
                                        $user['id_customer']
                                    );

                                    if ($last_date_forgotten_cart) {
                                        if ($this->setFormatToDate($last_date_forgotten_cart, $extrafield)) {
                                            $extrafields_users[$extrafield['name']] = $this->setFormatToDate(
                                                $last_date_forgotten_cart,
                                                $extrafield
                                            );
                                        }
                                    }
                                    break;

                                case 'ps_cart_forgotten_since_last_purchase':
                                    $total_carts = $this->getCustomerDateCartSinceLastPurchase(
                                        $user['id_customer']
                                    );
                                    $extrafields_users[$extrafield['name']] = $total_carts;
                                    break;
                            }
                        }  elseif ($extrafield['ps_group'] == 'address') {
                            switch ($extrafield['name']) {
                                case 'ps_address_state':
                                    if ($state_name)
                                        $extrafields_users[$extrafield['name']] = $state_name;
                                    break;
                                case 'ps_country':
                                    if ($country_name)
                                        $extrafields_users[$extrafield['name']] = $country_name;
                                    break;
                            }
                        }
                    }

                    // creamos el array con los datos del usuario
                    $to_export = array(
                        'contact'   =>  array(),
                        'groups'    =>  $group['mensagia_agenda_id']
                    );

                    // obtenemos los campos del contacto a exportar y que han escogido
                    if (in_array('ps_phone', $this->contact_fields))
                        $to_export['contact']['number'] = $phone_mobile;

                    if (in_array('ps_name', $this->contact_fields))
                        $to_export['contact']['name'] = $user['firstname'] . " " . $user['lastname'];

                    if (in_array('ps_email', $this->contact_fields))
                        $to_export['contact']['email'] = $user['email'];

                    if (in_array('ps_city', $this->contact_fields))
                        $to_export['contact']['city'] = $address->city;

                    if (in_array('ps_language', $this->contact_fields))
                        $to_export['contact']['language'] = strtolower(Language::getIsoById($user['id_lang']));

                    if ($this->blacklist_with_newsletter) {
                        foreach ($this->blacklists as $blacklist)
                        $to_export['contact'][$blacklist] = ($user['newsletter'] == 1) ? "0" : "1";
                    }

                    // añadimos extrafields si existen
                    if (count($extrafields_users)) {
                        $to_export['extra_fields'] = $extrafields_users;
                    }

                    // añadimos al array de válidos
                    array_push($valids, $to_export);
                }
            }

            // transformamos los validos en JSON
            $valids = json_encode($valids);

            $result = $this->mensagiaSDK->importByJSON($valids, $this->priority_field);

            if (isset($result['data'])) {
                array_push($this->groups[$actual_index_group]['processes'], $result['data']['process_id']);
                array_push($this->processes, $result['data']['process_id']);
            }
        }

        return array(
            'no_phone_mobile'   => $no_phone_mobile,
            'no_address'        => $no_address
        );
    }


    public function checkExtrafields()
    {
        $continue   = true;
        $errors     = "";
        $html       = "";

        if ($this->extrafields) {
            $html .= "<span style='font-weight:bold;font-size:14px;display:block;margin-top:15px;".
                "text-decoration: underline;margin-bottom:5px;'>".
                $this->mensagiaPrestashop->l('Extra fields')."</span>";

            foreach ($this->extrafields as $extrafield) {
                $html .= "<b>".$this->mensagiaPrestashop->l('Checking extra fields: ').
                    $extrafield['nameToShow']." (".$extrafield['name'].")</b><br>";

                // comprobamos si existe el campo personalizado, si no existe, lo creamos.
                if (! $this->mensagiaSDK->existsExtraField($extrafield['name'])) {
                    $html.= $this->icon_separator." ".
                        $this->mensagiaPrestashop->l('The extra field doesn\'t exist on Mensagia.')."<br>";

                    // creamos el campo personalizado en Mensagia

                    $parameters = array(
                        'name'  =>  $extrafield['name'],
                        'type'  =>  $extrafield['extra_field_type']
                    );

                    if ($extrafield['extra_field_type'] == 'date') {
                        if ($extrafield['date_format_type'] == 'date_format_lite') {
                            $parameters['date_format'] = $this->date_format_lite;
                        } elseif ($extrafield['date_format_type'] == 'date_format_full') {
                            $parameters['date_format'] = $this->date_format_full;
                        }
                        
                        // El campo lo creamos con dia y mes con fechas con dos dígitos
                        $parameters['date_format'] = str_replace('d', 'D', $parameters['date_format']);
                        $parameters['date_format'] = str_replace('m', 'M', $parameters['date_format']);
                    }

                    $newExtrafield = $this->mensagiaSDK->createExtraField($parameters);

                    if (isset($newExtrafield['data'])) {
                        $html.= $this->icon_separator." ".
                            $this->mensagiaPrestashop->l('Extra field created succesfully.')."<br>";
                    } else {
                        $html.= $this->icon_separator." ".
                            $this->mensagiaPrestashop->l('Error when creating an extra field').".<br>";
                        $errors.= $this->mensagiaPrestashop->l('Error when creating an extra field').": ".
                            $extrafield['nameToShow']." (".$extrafield['name'].")<br>";
                        $continue = false;
                    }
                } else {
                    $html.= $this->icon_separator." ".
                        $this->mensagiaPrestashop->l('The extra field already exists in Mensagia.')."<br>";
                }

                $this->jobs_done++;
            }
        }

        return json_encode(array(
            'html'      => $html,
            'options'   => get_object_vars($this),
            'errors'    => $errors,
            'continue'  => $continue,
        ));
    }

    public function deleteAgendas()
    {
        $html       = "";

        if ($this->groups) {
            $html .= "<span style='font-weight:bold;font-size:14px;display:block;margin-top:15px;".
                "text-decoration: underline;margin-bottom:5px;'>".
                $this->mensagiaPrestashop->l('Delete agendas')."</span>";

            foreach ($this->groups as $group) {
                $html .= "<b>".$this->mensagiaPrestashop->l('Deleting agenda: ').
                    $group['agenda_name_mensagia']."</b><br>";

                $agenda = $this->mensagiaSDK->existsAgendaByExactName($group['agenda_name_mensagia']);

                if ($agenda) {
                    $deleted = $this->mensagiaSDK->deleteAgendaByID($agenda['data'][0]['id']);

                    if ($deleted) {
                        $html.= $this->icon_separator." ".
                            $this->mensagiaPrestashop->l('Agenda deleted succesfully.')."<br>";
                    } else {
                        $html.= $this->icon_separator." ".
                            $this->mensagiaPrestashop->l('The agenda could not be deleted.')."<br>";
                    }
                } else {
                    $html.= $this->icon_separator." ".
                        $this->mensagiaPrestashop->l('The agenda doesn\'t exist in Mensagia.')."<br>";
                }

                $this->jobs_done++;
            }
        }

        $continue = true;
        $errors   = "";

        return json_encode(array(
            'html'      => $html,
            'options'   => get_object_vars($this),
            'errors'    => $errors,
            'continue'  => $continue,
        ));
    }

    public function createAgendas()
    {
        $html       = "";
        $errors     = "";
        $continue   = true;

        if (count($this->groups)) {
            $html .= "<span style='font-weight:bold;font-size:14px;display:block;margin-top:15px;".
                "text-decoration: underline;margin-bottom:5px;'>".
                $this->mensagiaPrestashop->l('Creating agenda in Mensagia')."</span>";

            foreach ($this->groups as $index => $group) {
                $html .= "<b>".$this->mensagiaPrestashop->l('Creating agenda: ').
                    $group['agenda_name_mensagia']."</b><br>";

                $agenda_exists = $this->mensagiaSDK->existsAgendaByExactName($group['agenda_name_mensagia']);

                if ($agenda_exists) {
                    $this->groups[$index]['mensagia_agenda_id'] = $agenda_exists['data'][0]['id'];
                    $html.= $this->icon_separator." ".
                        $this->mensagiaPrestashop->l('The agenda exists in Mensagia.')."<br>";
                } else {
                    $agenda = $this->mensagiaSDK->createAgenda($group['agenda_name_mensagia']);

                    if (isset($agenda['data'])) {
                        $this->groups[$index]['mensagia_agenda_id'] = $agenda['data']['id'];
                        $html.= $this->icon_separator." ".
                            $this->mensagiaPrestashop->l('Agenda created succesfully.')."<br>";
                    } else {
                        $html.= $this->icon_separator." ".
                            $this->mensagiaPrestashop->l('Error creating agenda').".<br>";
                        $errors.= $this->mensagiaPrestashop->l('Error creating agenda').": ".
                            $group['agenda_name_mensagia']."<br>";
                        $continue = false;
                    }
                }

                $this->jobs_done++;
            }
        }

        return json_encode(array(
            'html'      => $html,
            'options'   => get_object_vars($this),
            'errors'    => $errors,
            'continue'  => $continue,
        ));
    }

    public function exportInit()
    {
        $html = "<span style='font-weight:bold;font-size:14px;display:block;text-decoration: underline;margin-bottom:".
            "5px;'>".$this->mensagiaPrestashop->l('Preparing export groups to Mensagia')."</span>";

        $html.= $this->icon_separator." ". $this->mensagiaPrestashop
                ->l('Collecting information for export to Mensagia.')."<br>";

        // contamos cuantos usuarios tenemos por grupos
        $this->countPrestashopUsers();

        // variable para controlar si hay trabajos de exportación de usuarios
        $thereAreGroupsToExport = false;

        //Contamos el numero de trabajos a realizar
        if (count($this->groups)) {
            foreach ($this->groups as $index => $group) {
                $jobs_to_do = 0;

                // trabajos eliminar agendas
                if ($this->delete_agendas) {
                    $this->jobs++;
                }

                // trabajos crear agenda
                $this->jobs++;

                // trabajos exportar usuarios
                if ($group['count'] != 0) {
                    $thereAreGroupsToExport = true;

                    $jobs_to_do = $group['count'] / $this->limit;

                    if (($group['count'] % $this->limit) > 0) {
                        $jobs_to_do++;
                    }

                    $this->jobs = $this->jobs + (int) $jobs_to_do;
                }

                // nombre de la agenda en mensagia
                $this->groups[$index]['agenda_name_mensagia'] = $this->prefix_agenda.
                    $this->groups[$index]['group_name'];
                $this->groups[$index]['jobs']                 = (int) $jobs_to_do;
                $this->groups[$index]['jobs_done']            = (int) 0;
                $this->groups[$index]['export_started']       = false;
                $this->groups[$index]['processes']            = array();
            }
        }

        // trabajos para campos personalizados
        $this->jobs = $this->jobs + count($this->extrafields);

        // trabajos esperar que finalice de importart
        $this->jobs++;

        if ($thereAreGroupsToExport) {
            $this->next_index_group_to_export = 0;
        } else {
            $thereAreGroupsToExport = null;
        }

        $this->jobs_done = 0;

        $continue = true;
        $errors   = "";

        return json_encode(array(
            'html'      => $html,
            'options'   => get_object_vars($this),
            'errors'    => $errors,
            'continue'  => $continue,
        ));
    }


    private function countPrestashopUsers()
    {
        if (count($this->groups)) {
            foreach ($this->groups as $index => $group) {
                $result = Db::getInstance(_PS_USE_SQL_SLAVE_)->executeS('
                SELECT count(*) as count
                FROM `'._DB_PREFIX_.'customer` where active=1 AND id_default_group='.$group['group_id'].' ;');

                $this->groups[$index]['count'] = (int) $result[0]['count'];
            }
        }
    }
}
