
/**
 * NOTICE OF LICENSE
 *
 * This file is licenced under the Software License Agreement.
 * With the purchase or the installation of the software in your application
 * you accept the licence agreement.
 *
 * You must not modify, adapt or create derivative works of this source code
 *
 *  @author    Mensagia.com
 *  @copyright 2010-2015 Sinermedia
 *  @license   LICENSE.txt
 */
$(document).ready(function(){

    $("#sapi_configuration").change(function(e){
        show_remitente();
    });

    $(".copyToClipboard").click(function() {
        copyTextToClipboard($(".urlCallback").html());
        $(".copied").fadeIn();
        setTimeout(function(){
            $(".copied").fadeOut();
        }, 2000)
    });

    show_remitente();
});

function show_remitente() {
    optionSelected = $( "#sapi_configuration option:selected" );

    if (!optionSelected.val()){
        $(".groupSourceAddress").hide();
    } else
        $(".groupSourceAddress").show();

    allow_service_number_alias  = optionSelected.attr('allow_service_number_alias');
    sender_name                 = optionSelected.attr('sender_name');

    if (allow_service_number_alias == "true")
        $(".remitente").html(sender_name);
    else
        $(".remitente").html(no_dinamic_sender);
}

function fallbackCopyTextToClipboard(text) {
    var textArea = document.createElement("textarea");
    textArea.value = text;

    // Avoid scrolling to bottom
    textArea.style.top = "0";
    textArea.style.left = "0";
    textArea.style.position = "fixed";

    document.body.appendChild(textArea);
    textArea.focus();
    textArea.select();

    try {
        var successful = document.execCommand('copy');
        var msg = successful ? 'successful' : 'unsuccessful';
        console.log('Fallback: Copying text command was ' + msg);
    } catch (err) {
        console.error('Fallback: Oops, unable to copy', err);
    }

    document.body.removeChild(textArea);
}
function copyTextToClipboard(text) {
    if (!navigator.clipboard) {
        fallbackCopyTextToClipboard(text);
        return;
    }
    navigator.clipboard.writeText(text).then(function() {
        console.log('Async: Copying to clipboard was successful!');
    }, function(err) {
        console.error('Async: Could not copy text: ', err);
    });
}