<?php
/**
 * 2007-2015 PrestaShop
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License (AFL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/afl-3.0.php
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade PrestaShop to newer
 * versions in the future. If you wish to customize PrestaShop for your
 * needs please refer to http://www.prestashop.com for more information.
 *
 *  @author PrestaShop SA <contact@prestashop.com>
 *  @copyright  2007-2015 PrestaShop SA
 *  @license    http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
 *  International Registered Trademark & Property of PrestaShop SA
 */

if (!defined('_PS_VERSION_')) {
    exit;
}

require_once(_PS_MODULE_DIR_ . 'mensagiaprestashop/controllers/admin/MensagiaHookActionController.php');
require_once(_PS_MODULE_DIR_ . 'mensagiaprestashop/models/MensagiaSMSNotification.php');
require_once(_PS_MODULE_DIR_ . 'mensagiaprestashop/models/MensagiaAdmin.php');
require_once(_PS_MODULE_DIR_ . 'mensagiaprestashop/models/MensagiaCountry.php');
require_once(_PS_MODULE_DIR_ . 'mensagiaprestashop/classes/MensagiaSDK.php');

class mensagiaprestashop extends Module
{
    public $email;
    public $password;
    public $authenticated;
    public $prefix_mode;
    public $api_configuration;
    public $allow_blacklist_callbacks;
    public $mensagia_callbacks_blacklists;
    public $demo;

    public function __construct()
    {
        $this->demo                   = false;
        $this->name                   = 'mensagiaprestashop';
        $this->tab                    = 'mobile';
        $this->version                = '1.0.7';
        $this->author                 = 'Mensagia.com';
        $this->need_instance          = 1;
        $this->controllers            = array('Notifications', 'Configuration', 'Export');
        $this->bootstrap              = true;
        $this->ps_versions_compliancy = array('min' => '1.6', 'max' => _PS_VERSION_);

        parent::__construct();

        $this->displayName      = $this->l('Mensagia SMS');
        $this->description = $this->l('Connect your ecommerce with Mensagia to create hypersegmented campaigns and send automatic notifications through SMS or Email Marketing.');
        $this->confirmUninstall = $this->l('Are you sure to uninstall Mensagia SMS module?');

        $this->mensagiaSDK = new MensagiaSDK();

        /* Backward compatibility */
        if (_PS_VERSION_ < '1.5') {
            require(_PS_MODULE_DIR_.$this->name.'/backward_compatibility/backward.php');
        }

        $config = Configuration::getMultiple(array('MENSAGIA_LOGIN_EMAIL', 'MENSAGIA_LOGIN_PASSWORD',
            'MENSAGIA_AUTHENTICATED', 'MENSAGIA_PREFIX_MODE', 'MENSAGIA_API_CONFIGURATION', 'MENSAGIA_CALLBACKS_BLACKLISTS'));


        if (!empty($config['MENSAGIA_LOGIN_EMAIL'])) {
            $this->email = $config['MENSAGIA_LOGIN_EMAIL'];
        }

        if (!empty($config['MENSAGIA_LOGIN_PASSWORD'])) {
            $this->password = $config['MENSAGIA_LOGIN_PASSWORD'];
        }

        if (!empty($config['MENSAGIA_AUTHENTICATED'])) {
            $this->authenticated = $config['MENSAGIA_AUTHENTICATED'];
        }

        if (!empty($config['MENSAGIA_PREFIX_MODE'])) {
            $this->prefix_mode = $config['MENSAGIA_PREFIX_MODE'];
        }

        if (!empty($config['MENSAGIA_API_CONFIGURATION'])) {
            $this->api_configuration = $config['MENSAGIA_API_CONFIGURATION'];
        }

        if (!empty($config['MENSAGIA_CALLBACKS_BLACKLISTS'])) {
            $this->mensagia_callbacks_blacklists = $config['MENSAGIA_CALLBACKS_BLACKLISTS'];
        }

        $warnings = "";


        if (!isset($this->email) || !isset($this->password)) {
            $warnings .=  $this->l("You must enter your Mensagia's access data before using this module")."\n";
        } else {
            if (! $this->authenticated) {
                $warnings .=  $this->l("You must enter a valid Mensagia account before using this module")."\n";
            }
        }

        if ($this->authenticated) {
            if (MensagiaAdmin::countAdmins() == 0) {
                $warnings .= $this->l("You must create at least one administrator.")."\n";
            }
        }

        if (! $this->prefix_mode) {
            $warnings .= $this->l('You must choose how to manage the prefixes.');
        }

        if (! $this->api_configuration) {
            $warnings .= $this->l('You must choose the delivery configuration in order to send the SMS.');
        }

        if ($warnings) {
            $this->warning = $warnings;
        }
    }

    public function install()
    {
        if (Shop::isFeatureActive()) {
            Shop::setContext(Shop::CONTEXT_ALL);
        }

        if (!parent::install()) {
            return false;
        }

        Configuration::updateValue('MENSAGIA_AUTHENTICATED', false);
        Configuration::updateValue('MENSAGIA_PREFIX_MODE', 'check_prefixs');
        Configuration::updateValue('MENSAGIA_CALLBACKS_BLACKLISTS', "sms,mail,voice");

        $this->installSQL();
        $this->notificationsSQL();

        $this->createTab("MensagiaSMS", "Mensagia SMS", 0);

        $idParent = Tab::getIdFromClassName("MensagiaSMS");

        $this->createTab(
            "AdminMensagiaNotifications",
            $this->l('SMS notifications'),
            $idParent
        );

        $this->createTab(
            "AdminMensagiaExport",
            $this->l('Export to Mensagia'),
            $idParent
        );

        $this->createTab(
            "AdminMensagiaConfiguration",
            $this->l('Configuration'),
            $idParent
        );

        // Register hooks
        $this->registerHook('actionOrderStatusPostUpdate');

        $this->registerHook('actionValidateOrder');
        $this->registerHook('actionPaymentConfirmation');
        $this->registerHook('actionOrderReturn');

        $this->registerHook('actionCustomerAccountAdd');

        //$this->registerHook('actionProductOutOfStock');
        $this->registerHook('actionProductDelete');
        $this->registerHook('actionProductDelete');

        return true;
    }


    public function uninstall()
    {
        if (!parent::uninstall() || !Configuration::deleteByName('mensagiaprestashop') ||
            !Configuration::deleteByName('MENSAGIA_LOGIN_EMAIL') ||
            !Configuration::deleteByName('MENSAGIA_LOGIN_PASSWORD') ||
            !Configuration::deleteByName('MENSAGIA_AUTHENTICATED') ||
            !Configuration::deleteByName('MENSAGIA_API_CONFIGURATION')||
            !Configuration::deleteByName('MENSAGIA_ALLOW_BLACKLIST_CALLBACKS')||
            !Configuration::deleteByName('MENSAGIA_PREFIX_MODE')||
            !Configuration::deleteByName('MENSAGIA_CALLBACKS_BLACKLISTS')) {
            return false;
        }

        //hooks
        $this->unregisterHook('actionOrderStatusPostUpdate');
        $this->unregisterHook('actionValidateOrder');
        $this->unregisterHook('actionPaymentConfirmation');
        $this->unregisterHook('actionOrderReturn');
        $this->unregisterHook('actionCustomerAccountAdd');
        //$this->unregisterHook('actionProductOutOfStock');
        $this->unregisterHook('actionProductDelete');

        // deleteSQL
        Db::getInstance()->Execute("DROP TABLE IF EXISTS " . _DB_PREFIX_ . "mensagia_sms_notifications");
        Db::getInstance()->Execute("DROP TABLE IF EXISTS " . _DB_PREFIX_ . "mensagia_sms_notifications_lang");
        Db::getInstance()->Execute("DROP TABLE IF EXISTS " . _DB_PREFIX_ . "mensagia_admins");
        Db::getInstance()->Execute("DROP TABLE IF EXISTS " . _DB_PREFIX_ . "mensagia_countries");

        // delete tabs
        $this->deleteTab('AdminMensagiaNotificationsController');
        $this->deleteTab('AdminMensagiaConfiguration');
        $this->deleteTab('AdminMensagiaExport');

        return true;
    }

    public function hookActionProductOutOfStock($params)
    {
        $controller_hook = MensagiaHookActionController::getInstance();

        // admin
        $hook = MensagiaSMSNotification::isHookEnabled('actionProductOutOfStock', 'admin');

        if ($hook) {
            $result = $controller_hook->sendNotification($params, $hook, 'admin');

            $this->addErrorsHooksToContext($result);
        }
    }

    public function hookActionProductDelete($params)
    {
        $controller_hook = MensagiaHookActionController::getInstance();

        // admin
        $hook = MensagiaSMSNotification::isHookEnabled('actionProductDelete', 'admin');

        if ($hook) {
            $result = $controller_hook->sendNotification($params, $hook, 'admin');

            $this->addErrorsHooksToContext($result);
        }
    }


    public function hookActionCustomerAccountAdd($params)
    {
        $controller_hook = MensagiaHookActionController::getInstance();

        // admin
        $hook = MensagiaSMSNotification::isHookEnabled('actionCustomerAccountAdd', 'admin');

        if ($hook) {
            $result = $controller_hook->sendNotification($params, $hook, 'admin');

            $this->addErrorsHooksToContext($result);
        }
    }

    public function hookActionValidateOrder($params)
    {
        $controller_hook = MensagiaHookActionController::getInstance();

        // customer
        $hook = MensagiaSMSNotification::isHookEnabled('actionValidateOrder', 'customer');

        if ($hook) {
            $result = $controller_hook->sendNotification($params, $hook, 'customer');

            $this->addErrorsHooksToContext($result);
        }

        // admin
        $hook = MensagiaSMSNotification::isHookEnabled('actionValidateOrder', 'admin');

        if ($hook) {
            $result = $controller_hook->sendNotification($params, $hook, 'admin');

            $this->addErrorsHooksToContext($result);
        }
    }

    public function hookActionPaymentConfirmation($params)
    {
        $controller_hook = MensagiaHookActionController::getInstance();

        // customer
        $hook = MensagiaSMSNotification::isHookEnabled('actionPaymentConfirmation', 'customer');

        if ($hook) {
            $result = $controller_hook->sendNotification($params, $hook, 'customer');

            $this->addErrorsHooksToContext($result);
        }

        // admin
        $hook = MensagiaSMSNotification::isHookEnabled('actionPaymentConfirmation', 'admin');

        if ($hook) {
            $result = $controller_hook->sendNotification($params, $hook, 'admin');

            $this->addErrorsHooksToContext($result);
        }
    }

    public function hookActionOrderReturn($params)
    {
        $controller_hook = MensagiaHookActionController::getInstance();

        // customer
        $hook = MensagiaSMSNotification::isHookEnabled('actionOrderReturn', 'customer');

        if ($hook) {
            $result = $controller_hook->sendNotification($params, $hook, 'customer');

            $this->addErrorsHooksToContext($result);
        }

        // admin
        $hook = MensagiaSMSNotification::isHookEnabled('actionOrderReturn', 'admin');

        if ($hook) {
            $result = $controller_hook->sendNotification($params, $hook, 'admin');

            $this->addErrorsHooksToContext($result);
        }
    }



    public function hookActionOrderStatusPostUpdate($params)
    {
        $controller_hook = MensagiaHookActionController::getInstance();

        // customer
        $hook = MensagiaSMSNotification::isHookEnabled(
            'actionOrderStatusPostUpdate',
            'customer',
            $params['newOrderStatus']->id
        );

        if ($hook) {
            $result = $controller_hook->sendNotification($params, $hook, 'customer');
            $this->addErrorsHooksToContext($result);
        }

        // admin
        $hook = MensagiaSMSNotification::isHookEnabled(
            'actionOrderStatusPostUpdate',
            'admin',
            $params['newOrderStatus']->id
        );

        if ($hook) {
            $result = $controller_hook->sendNotification($params, $hook, 'admin');

            $this->addErrorsHooksToContext($result);
        }
    }

    private function addErrorsHooksToContext($result)
    {
        if ($result['result'] == 'error') {
            foreach ($result['error_messages'] as $error_message) {
                $this->context->controller->errors[] = $this->l($error_message);
            }
        } elseif ($result['result'] == 'error-whithout-number') {
            $this->context->controller->errors[] = $this->l('No se ha podido enviar la notificación
             por SMS al contacto '.$result['full_name'].' porque no dispone de número de móvil 
             en la dirección de envío escogida.');
        } else {
            if (isset($result['message'])) {
                $this->context->controller->errors[] = $this->l($result['message']);
            }
        }
    }


    /**
     * @return string
     */
    public function getContent()
    {
        $output       = null;
        $outputErrors = array();

        if ($this->demo) {
            if (Tools::isSubmit('api_configurations') or  Tools::isSubmit('prefix_mode_submit')
            or Tools::isSubmit('delete_admins') or Tools::isSubmit('create_admins') or
            Tools::isSubmit('submit'.$this->name)) {
                $output .= $this->displayWarning($this->l('Demo data can not be modified'));
            }
        } else {
            if (Tools::isSubmit('api_configurations')) {
                $api_configuration   = (string)Tools::getValue('sapi_configuration');

                if ($api_configuration) {
                    Configuration::updateValue('MENSAGIA_API_CONFIGURATION', $api_configuration);
                    $output .= $this->displayConfirmation($this->l('Option saved successfully.'));
                } else {
                    $output .= $this->displayError($this->l('You have not chosen any delivery settings.'));
                }
            }

            if (Tools::isSubmit('prefix_mode_submit')) {
                $prefix_mode   = (string)Tools::getValue('prefix_mode');

                if ($prefix_mode) {
                    Configuration::updateValue('MENSAGIA_PREFIX_MODE', $prefix_mode);
                    $output .= $this->displayConfirmation($this->l('Option saved successfully.'));
                } else {
                    $output .= $this->displayError($this->l('You have not chosen any option for managing the prefixes.'));
                }
            }

            if (Tools::isSubmit('blacklist_with_newsletter_submit')) {

                $sms_blacklist   = (string)Tools::getValue('sms_blacklist');
                $mail_blacklist  = (string)Tools::getValue('mail_blacklist');
                $voz_blacklist   = (string)Tools::getValue('voz_blacklist');

                $array_options_blacklist = [];

                if ($sms_blacklist and $sms_blacklist == 'sms')
                    array_push($array_options_blacklist, 'sms');

                if ($mail_blacklist and $mail_blacklist == 'mail')
                    array_push($array_options_blacklist, 'mail');

                if ($voz_blacklist and $voz_blacklist == 'voice')
                    array_push($array_options_blacklist, 'voice');

                if (count($array_options_blacklist)) {
                    Configuration::updateValue('MENSAGIA_CALLBACKS_BLACKLISTS', implode(',', $array_options_blacklist));
                    $output .= $this->displayConfirmation($this->l('Option saved successfully.'));
                } else {
                    $output .= $this->displayError($this->l('You must choose at least one Black List.'));
                }
            }

            if (Tools::isSubmit('delete_admins')) {
                $admin_id   = (string)Tools::getValue('admin_id');

                if ($admin_id) {
                    $result = MensagiaAdmin::remove($admin_id);

                    if ($result) {
                        $output .= $this->displayConfirmation($this->l('Administrator successfully deleted.'));
                    } else {
                        $output .= $this->displayError($this->l('Error removing administrator.'));
                    }
                }
            }

            if (Tools::isSubmit('create_admins')) {
                $name   = (string)Tools::getValue('admin_name');
                $number = (string)Tools::getValue('admin_mobile');

                if ($name && $number) {
                    if (! MensagiaAdmin::exists($number)) {
                        $result = MensagiaAdmin::create($name, $number);

                        if ($result) {
                            $output .= $this->displayConfirmation($this->l('Administrator created correctly.'));
                        } else {
                            $output .= $this->displayError($this->l('Error creating administrator.'));
                        }
                    } else {
                        $output .= $this->displayError(
                            $this->l('An administrator already exists with this number.')
                        );
                    }
                } else {
                    $output .= $this->displayError($this->l('Incorrect data'));
                }
            }


            if (Tools::isSubmit('submit'.$this->name)) {
                $email          = (string)Tools::getValue('MENSAGIA_LOGIN_EMAIL');
                $password       = (string)Tools::getValue('MENSAGIA_LOGIN_PASSWORD');

                if (!$email || empty($email) || !Validate::isGenericName($email)) {
                    $output .= $this->displayError($this->l('You must enter a valid email address'));
                } elseif (!$password || empty($password)) {
                    $output .= $this->displayError($this->l('You must enter a valid password'));
                } else {
                    $auth = $this->mensagiaSDK->authenticate($email, $password);

                    Configuration::updateValue('MENSAGIA_LOGIN_EMAIL', $email);
                    Configuration::updateValue('MENSAGIA_LOGIN_PASSWORD', $password);

                    if ($auth['result'] == 'success') {
                        Configuration::updateValue('MENSAGIA_AUTHENTICATED', true);
                        $output .= $this->displayConfirmation($this->l('Account connected!'));
                    } else {
                        Configuration::updateValue('MENSAGIA_AUTHENTICATED', false);
                        $output .= $this->displayError(
                            $this->l(
                                'The access data does not correspond to any active Mensagia account.'
                            )
                        );
                    }
                }
            }
        }

        $login                          = (string)Configuration::get('MENSAGIA_LOGIN_EMAIL');
        $password                       = (string)Configuration::get('MENSAGIA_LOGIN_PASSWORD');
        $connected                      = (bool)Configuration::get('MENSAGIA_AUTHENTICATED');
        $api_configuration              = (string)Configuration::get('MENSAGIA_API_CONFIGURATION');
        $blacklist_with_newsletter      = (bool)Configuration::get('MENSAGIA_ALLOW_BLACKLIST_CALLBACKS');
        $mensagia_callbacks_blacklists  =  Configuration::get('MENSAGIA_CALLBACKS_BLACKLISTS');
        $balance                        = null;


        //buscamos las configuraciones de envío
        if ($connected) {
            $this->mensagiaSDK->authenticate($login, $password);
            $api_configurations = $this->mensagiaSDK->getApiConfigurations();
            $balance            = $this->mensagiaSDK->getBalance();


            if (isset($balance['data'])) {
                $balance = number_format(
                    $balance['data']['balance'],
                    4,
                    ',',
                    '.'
                ).$balance['data']['currency'];
            }

            if (isset($api_configurations['data'])) {
                if ($api_configurations['meta']['pagination']['total'] > 0) {
                    $api_configurations =  $api_configurations['data'];
                } else {
                    $api_configurations = null;
                    //array_push($outputErrors, $this->l('You must create a delivery setting in Mensagia.'));
                }
            } else {
                $api_configurations = null;
                //array_push($outputErrors, $this->l('You must choose a delivery setting in Mensagia.'));
            }
        } else {
            $api_configurations = null;
            array_push($outputErrors, $this->l('You must sign in your Mensagia account.'));
        }

        // buscamos los administradores
        $admins = MensagiaAdmin::getAdmins();

        /*
        // mostramos error si no ha escogido configuración pero la tiene creada
        if (!$api_configuration) {
            if (!in_array($this->l('You must choose a delivery setting in Mensagia.'), $outputErrors)) {
                array_push($outputErrors, $this->l('You must choose a delivery setting in Mensagia.'));
            }
        }

        // mostramos errores de admin
        if (!count($admins)) {
            array_push($outputErrors, $this->l('You must create at least one administrator'));
        }*/

        // mostramos los errores para guiar al usuario
        if (count($outputErrors)) {
            $output .= $this->displayError($outputErrors);
        }

        $this->context->smarty->assign(array(
        'nodinamicsendertxt' => $this->l('The sending configuration chosen does not allow dynamic senders.'),
        'login'              => $login,
        'output'             => $output,
        'connected'          => $connected,
        'admins'             => $admins,
        'api_configuration'  => $api_configuration,
        'api_configurations' => $api_configurations,
        'balance'            => $balance,
        'blacklist_with_newsletter' => $blacklist_with_newsletter,
        'mensagia_callbacks_blacklists' => $mensagia_callbacks_blacklists,
        'prefix_mode'        => Configuration::get('MENSAGIA_PREFIX_MODE'),
        'bootboxDir'         => _MODULE_DIR_ . 'mensagiaprestashop/views/js/bootbox.min.js',
        'jsDir'              => _MODULE_DIR_ . 'mensagiaprestashop/views/js/configuration.js',
        'action'             => AdminController::$currentIndex . '&configure=' . $this->name . '&save' . $this->name .
            '&token='.Tools::getAdminTokenLite('AdminModules'),
        ));

        $template =_PS_MODULE_DIR_.'/mensagiaprestashop/views/templates/admin/mensagia_configuration/configuration.tpl';
        return $this->context->smarty->fetch($template);
    }

    public function setMedia($isNewTheme = false)
    {
        parent::setMedia($isNewTheme);
        $this->addJS(_MODULE_DIR_.'mensagia_prestashop/views/js/bootbox.min.js');
    }

    public function checkAuthentification($email, $password)
    {
        // Enter your email and password to access the site
        define('EMAIL', $email);
        define('PASSWORD', $password);

        // Do not change this
        define('BASE_URI', 'https://api.mensagia.com/');
        define('API_VERSION', 'v1');
        define('URL_ACCESS_TOKEN', API_VERSION.'/login');

        // API AUTHENTIFICATION
        $data = array(
            'email'             =>   EMAIL,
            'password'          =>   PASSWORD,
        );

        // CURL REQUEST
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, BASE_URI.URL_ACCESS_TOKEN);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($data));
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        $output = curl_exec($ch);
        //$error = curl_error($ch);
        curl_close($ch);

        $output = json_decode($output, true);

        // CHECK THE REQUEST
        if (! isset($output['error'])) {
            return $output['data'];
        } else {
            return false;
        }
    }

    public function createTab($tabClass, $tabName, $idParent)
    {
        $tab = new Tab();
        foreach (Language::getLanguages(false) as $lang) {
            $tab->name[(int) $lang['id_lang']] = $tabName;
        }
        $tab->class_name = $tabClass;
        $tab->module = $this->name;
        $tab->id_parent = $idParent;

        if ($tabClass == 'AdminMensagiaNotifications') {
            $tab->icon = "sms";
        } elseif ($tabClass == 'AdminMensagiaExport') {
            $tab->icon = "import_export";
        } elseif ($tabClass == 'AdminMensagiaConfiguration') {
            $tab->icon = "settings";
        }

        if (!$tab->save()) {
            return false;
        }
        return true;
    }

    public function deleteTab($tabClass)
    {
        $idTab = Tab::getIdFromClassName($tabClass);
        if ($idTab != 0) {
            $tab = new Tab($idTab);
            $tab->delete();
            return true;
        }
        return false;
    }

    public function getProducts()
    {
        $id_category = Tools::getValue('id_category');

        $category = new Category($id_category, $this->context->language->id);

        $products = $category->getProducts($this->context->language->id, 0, 1000);

        $html = '';

        if ($products) {
            foreach ($products as $product) {
                $html .= '<tr><td>'.$product['id_product'].'</td><td>'.$product['name'].'</td></tr>';
            }
        }

        return $html;
    }

    public function installSQL()
    {
        Db::getInstance()->Execute("CREATE TABLE IF NOT EXISTS " . _DB_PREFIX_ . "mensagia_sms_notifications (
            `id` INT(9) NOT NULL AUTO_INCREMENT,
            `type` VARCHAR(100) CHARACTER SET utf8 NOT NULL,
            `hook` VARCHAR(100) CHARACTER SET utf8 NOT NULL,
            `option_id` INT(9),
            `active` TINYINT(1)  NOT NULL DEFAULT 0,
            PRIMARY KEY (`id`)
            ) ENGINE=InnoDB  DEFAULT CHARSET=utf8;");


        Db::getInstance()->Execute("CREATE TABLE IF NOT EXISTS " . _DB_PREFIX_ . "mensagia_sms_notifications_lang (
            `id` INT(9) NOT NULL AUTO_INCREMENT,
            `mensagia_sms_notification_id` INT(9),
            `lang_id` INT(9),
            `message` TEXT CHARACTER SET utf8 ,
            PRIMARY KEY (`id`)
            ) ENGINE=InnoDB  DEFAULT CHARSET=utf8;");


        Db::getInstance()->Execute("CREATE TABLE IF NOT EXISTS " . _DB_PREFIX_ . "mensagia_admins (
            `id` INT(9) NOT NULL AUTO_INCREMENT,
            `name` VARCHAR(255) CHARACTER SET utf8 NOT NULL,
            `number` VARCHAR(20) CHARACTER SET utf8 NOT NULL,
            PRIMARY KEY (`id`)
            ) ENGINE=InnoDB  DEFAULT CHARSET=utf8;");


        Db::getInstance()->Execute("CREATE TABLE IF NOT EXISTS " . _DB_PREFIX_ . "mensagia_countries (
            `id` INT(9) NOT NULL AUTO_INCREMENT,
            `code` varchar(2) NOT NULL DEFAULT '',
            `name` varchar(50) NOT NULL DEFAULT '',
            `native` varchar(50) NOT NULL DEFAULT '',
            `phone` varchar(15) NOT NULL DEFAULT '',
            `continent` varchar(2) NOT NULL DEFAULT '',
            `capital` varchar(50) NOT NULL DEFAULT '',
            `currency` varchar(30) NOT NULL DEFAULT '',
            `languages` varchar(30) NOT NULL DEFAULT '',
            `min_length_number` int4 DEFAULT 6,
            `max_length_number` int4 DEFAULT 15,
            `allowed_firsts_number` varchar(255) DEFAULT '',
            `name_en` varchar(50) NOT NULL DEFAULT '',
            PRIMARY KEY (`id`)
            ) ENGINE=InnoDB  DEFAULT CHARSET=utf8;");


        if (!Db::getInstance()->ExecuteS("SELECT * FROM " . _DB_PREFIX_ . "mensagia_countries")) {
            Db::getInstance()->Execute("INSERT INTO " . _DB_PREFIX_ . "mensagia_countries VALUES
         ('1', 'ES', 'España', 'España', '34', 'EU', 'Madrid', 'EUR', 'es,eu,ca,gl,oc', '11', '11', '6,7', ''),
         ('2', 'AD', 'Andorra', 'Andorra', '376', 'EU', 'Andorra la Vella', 'EUR', 'ca', '6', '15', '', ''),
         ('3', 'AE', 'United Arab Emirates',
          'دولة الإمارات العربية المتحدة'
         , '971', 'AS', 'Abu Dhabi', 'AED','ar', '6', '15', '', ''),
         ('4', 'AF', 'Afghanistan', 'افغانستان', '93', 'AS', 'Kabul', 'AFN', 'ps,uz,tk', '6', '15', '', ''),
         ('5', 'AG', 'Antigua and Barbuda', 'Antigua and Barbuda', '1268', 'NA', 'Saint John''s', 'XCD', 'en',
          '6', '15', '', ''),
         ('6', 'AI', 'Anguilla', 'Anguilla', '1264', 'NA', 'The Valley', 'XCD', 'en', '6', '15', '', ''),
         ('7', 'AL', 'Albania', 'Shqipëria', '355', 'EU', 'Tirana', 'ALL', 'sq', '6', '15', '', ''),
         ('8', 'AM', 'Armenia', 'Հայաստան', '374', 'AS', 'Yerevan', 'AMD', 'hy,ru', '6', '15', '', ''),
         ('9', 'AO', 'Angola', 'Angola', '244', 'AF', 'Luanda', 'AOA', 'pt', '6', '15', '', ''),
         ('10', 'AQ', 'Antarctica', '', '', 'AN', '', '', '', '6', '15', '', ''),
         ('11', 'AR', 'Argentina', 'Argentina', '54', 'SA', 'Buenos Aires', 'ARS', 'es,gn', '6', '15', '', ''),
         ('12', 'AS', 'American Samoa', 'American Samoa', '1684', 'OC', 'Pago Pago', 'USD', 'en,sm', '6', '15',
          '', ''),
         ('13', 'AT', 'Austria', 'Österreich', '43', 'EU', 'Vienna', 'EUR', 'de', '6', '15', '', ''),
         ('14', 'AU', 'Australia', 'Australia', '61', 'OC', 'Canberra', 'AUD', 'en', '6', '15', '', ''),
         ('15', 'AW', 'Aruba', 'Aruba', '297', 'NA', 'Oranjestad', 'AWG', 'nl,pa', '6', '15', '', ''),
         ('16', 'AX', 'Åland', 'Åland', '358', 'EU', 'Mariehamn', 'EUR', 'sv', '6', '15', '', ''),
         ('17', 'AZ', 'Azerbaijan', 'Azərbaycan', '994', 'AS', 'Baku', 'AZN', 'az,hy', '6', '15', '', ''),
         ('18', 'BA', 'Bosnia and Herzegovina', 'Bosna i Hercegovina', '387', 'EU', 'Sarajevo', 'BAM',
          'bs,hr,sr', '6', '15', '', ''),
         ('19', 'BB', 'Barbados', 'Barbados', '1246', 'NA', 'Bridgetown', 'BBD', 'en', '6', '15', '', ''),
         ('20', 'BD', 'Bangladesh', 'Bangladesh', '880', 'AS', 'Dhaka', 'BDT', 'bn', '6', '15', '', ''),
         ('21', 'BE', 'Belgium', 'België', '32', 'EU', 'Brussels', 'EUR', 'nl,fr,de', '6', '15', '', ''),
         ('22', 'BF', 'Burkina Faso', 'Burkina Faso', '226', 'AF', 'Ouagadougou', 'XOF', 'fr,ff', '6', '15',
          '', ''),
         ('23', 'BG', 'Bulgaria', 'България', '359', 'EU', 'Sofia', 'BGN', 'bg', '6', '15', '', ''),
         ('24', 'BH', 'Bahrain', '‏البحرين', '973', 'AS', 'Manama', 'BHD', 'ar', '6', '15', '', ''),
         ('25', 'BI', 'Burundi', 'Burundi', '257', 'AF', 'Bujumbura', 'BIF', 'fr,rn', '6', '15', '', ''),
         ('26', 'BJ', 'Benin', 'Bénin', '229', 'AF', 'Porto-Novo', 'XOF', 'fr', '6', '15', '', ''),
         ('27', 'BL', 'Saint Barthélemy', 'Saint-Barthélemy', '590', 'NA', 'Gustavia', 'EUR', 'fr', '6',
          '15', '', ''),
         ('28', 'BM', 'Bermuda', 'Bermuda', '1441', 'NA', 'Hamilton', 'BMD', 'en', '6', '15', '', ''),
         ('29', 'BN', 'Brunei', 'Negara Brunei Darussalam', '673', 'AS', 'Bandar Seri Begawan', 'BND', 'ms',
          '6', '15', '', ''),
         ('30', 'BO', 'Bolivia', 'Bolivia', '591', 'SA', 'Sucre', 'BOB,BOV', 'es,ay,qu', '6', '15', '', ''),
         ('31', 'BQ', 'Bonaire', 'Bonaire', '5997', 'NA', 'Kralendijk', 'USD', 'nl', '6', '15', '', ''),
         ('32', 'BR', 'Brazil', 'Brasil', '55', 'SA', 'Brasília', 'BRL', 'pt', '6', '15', '', ''),
         ('33', 'BS', 'Bahamas', 'Bahamas', '1242', 'NA', 'Nassau', 'BSD', 'en', '6', '15', '', ''),
         ('34', 'BT', 'Bhutan', 'ʼbrug-yul', '975', 'AS', 'Thimphu', 'BTN,INR', 'dz', '6', '15', '', ''),
         ('35', 'BV', 'Bouvet Island', 'Bouvetøya', '', 'AN', '', 'NOK', '', '6', '15', '', ''),
         ('36', 'BW', 'Botswana', 'Botswana', '267', 'AF', 'Gaborone', 'BWP', 'en,tn', '6', '15', '', ''),
         ('37', 'BY', 'Belarus', 'Белару́сь', '375', 'EU', 'Minsk', 'BYR', 'be,ru', '6', '15', '', ''),
         ('38', 'BZ', 'Belize', 'Belize', '501', 'NA', 'Belmopan', 'BZD', 'en,es', '6', '15', '', ''),
         ('39', 'CA', 'Canada', 'Canada', '1', 'NA', 'Ottawa', 'CAD', 'en,fr', '6', '15', '', ''),
         ('40', 'CC', 'Cocos [Keeling] Islands', 'Cocos (Keeling) Islands', '61', 'AS', 'West Island',
          'AUD', 'en', '6', '15', '', ''),
         ('41', 'CD', 'Democratic Republic of the Congo', 'République démocratique du Congo', '243', 'AF',
          'Kinshasa', 'CDF', 'fr,ln,kg,sw,lu', '6', '15', '', ''),
         ('42', 'CF', 'Central African Republic', 'Ködörösêse tî Bêafrîka', '236', 'AF', 'Bangui', 'XAF',
          'fr,sg', '6', '15', '', ''),
         ('43', 'CG', 'Republic of the Congo', 'République du Congo', '242', 'AF', 'Brazzaville', 'XAF',
          'fr,ln', '6', '15', '', ''),
         ('44', 'CH', 'Switzerland', 'Schweiz', '41', 'EU', 'Bern', 'CHE,CHF,CHW', 'de,fr,it', '6', '15',
          '', ''),
         ('45', 'CI', 'Ivory Coast', 'Côte d''Ivoire', '225', 'AF', 'Yamoussoukro', 'XOF', 'fr', '6',
          '15', '', ''),
         ('46', 'CK', 'Cook Islands', 'Cook Islands', '682', 'OC', 'Avarua', 'NZD', 'en', '6', '15',
          '', ''),
         ('47', 'CL', 'Chile', 'Chile', '56', 'SA', 'Santiago', 'CLF,CLP', 'es', '6', '15', '', ''),
         ('48', 'CM', 'Cameroon', 'Cameroon', '237', 'AF', 'Yaoundé', 'XAF', 'en,fr', '6', '15', '',
          ''),
         ('49', 'CN', 'China', '中国', '86', 'AS', 'Beijing', 'CNY', 'zh', '6', '15', '', ''),
         ('50', 'CO', 'Colombia', 'Colombia', '57', 'SA', 'Bogotá', 'COP', 'es', '6', '15', '', ''),
         ('51', 'CR', 'Costa Rica', 'Costa Rica', '506', 'NA', 'San José', 'CRC', 'es', '6', '15', '',
          ''),
         ('52', 'CU', 'Cuba', 'Cuba', '53', 'NA', 'Havana', 'CUC,CUP', 'es', '6', '15', '', ''),
         ('53', 'CV', 'Cape Verde', 'Cabo Verde', '238', 'AF', 'Praia', 'CVE', 'pt', '6', '15', '', ''),
         ('54', 'CW', 'Curacao', 'Curaçao', '5999', 'NA', 'Willemstad', 'ANG', 'nl,pa,en', '6', '15',
          '', ''),
         ('55', 'CX', 'Christmas Island', 'Christmas Island', '61', 'AS', 'Flying Fish Cove', 'AUD',
          'en', '6', '15', '', ''),
         ('56', 'CY', 'Cyprus', 'Κύπρος', '357', 'EU', 'Nicosia', 'EUR', 'el,tr,hy', '6', '15', '', ''),
         ('57', 'CZ', 'Czechia', 'Česká republika', '420', 'EU', 'Prague', 'CZK', 'cs,sk', '6', '15',
          '', ''),
         ('58', 'DE', 'Germany', 'Deutschland', '49', 'EU', 'Berlin', 'EUR', 'de', '6', '15', '', ''),
         ('59', 'DJ', 'Djibouti', 'Djibouti', '253', 'AF', 'Djibouti', 'DJF', 'fr,ar', '6', '15', '', ''),
         ('60', 'DK', 'Denmark', 'Danmark', '45', 'EU', 'Copenhagen', 'DKK', 'da', '6', '15', '', ''),
         ('61', 'DM', 'Dominica', 'Dominica', '1767', 'NA', 'Roseau', 'XCD', 'en', '6', '15', '', ''),
         ('62', 'DO', 'Dominican Republic', 'República Dominicana', '1809,1829,1849', 'NA',
          'Santo Domingo', 'DOP', 'es', '6', '15', '', ''),
         ('63', 'DZ', 'Algeria', 'الجزائر', '213', 'AF', 'Algiers', 'DZD', 'ar', '6', '15', '', ''),
         ('64', 'EC', 'Ecuador', 'Ecuador', '593', 'SA', 'Quito', 'USD', 'es', '6', '15', '', ''),
         ('65', 'EE', 'Estonia', 'Eesti', '372', 'EU', 'Tallinn', 'EUR', 'et', '6', '15', '', ''),
         ('66', 'EG', 'Egypt', 'مصر‎', '20', 'AF', 'Cairo', 'EGP', 'ar', '6', '15', '', ''),
         ('67', 'EH', 'Western Sahara', 'الصحراء الغربية', '212', 'AF', 'El Aaiún', 'MAD,DZD,MRO', 'es',
          '6', '15', '', ''),
         ('68', 'ER', 'Eritrea', 'ኤርትራ', '291', 'AF', 'Asmara', 'ERN', 'ti,ar,en', '6', '15', '', ''),
         ('69', 'ET', 'Ethiopia', 'ኢትዮጵያ', '251', 'AF', 'Addis Ababa', 'ETB', 'am', '6', '15', '', ''),
         ('70', 'FI', 'Finland', 'Suomi', '358', 'EU', 'Helsinki', 'EUR', 'fi,sv', '6', '15', '', ''),
         ('71', 'FJ', 'Fiji', 'Fiji', '679', 'OC', 'Suva', 'FJD', 'en,fj,hi,ur', '6', '15', '', ''),
         ('72', 'FK', 'Falkland Islands', 'Falkland Islands', '500', 'SA', 'Stanley', 'FKP', 'en', '6',
          '15', '', ''),
         ('73', 'FM', 'Micronesia', 'Micronesia', '691', 'OC', 'Palikir', 'USD', 'en', '6', '15', '', ''),
         ('74', 'FO', 'Faroe Islands', 'Føroyar', '298', 'EU', 'Tórshavn', 'DKK', 'fo', '6', '15', '', ''),
         ('75', 'FR', 'France', 'France', '33', 'EU', 'Paris', 'EUR', 'fr', '6', '15', '', ''),
         ('76', 'GA', 'Gabon', 'Gabon', '241', 'AF', 'Libreville', 'XAF', 'fr', '6', '15', '', ''),
         ('77', 'GB', 'United Kingdom', 'United Kingdom', '44', 'EU', 'London', 'GBP', 'en', '6', '15', '',
          ''),
         ('78', 'GD', 'Grenada', 'Grenada', '1473', 'NA', 'St. George''s', 'XCD', 'en', '6', '15', '', ''),
         ('79', 'GE', 'Georgia',
          'საქართველო',
           '995', 'AS', 'Tbilisi', 'GEL', 'ka', '6', '15', '', ''),
         ('80', 'GF', 'French Guiana', 'Guyane française', '594', 'SA', 'Cayenne', 'EUR', 'fr', '6', '15',
          '', ''),
         ('81', 'GG', 'Guernsey', 'Guernsey', '44', 'EU', 'St. Peter Port', 'GBP', 'en,fr', '6', '15',
          '', ''),
         ('82', 'GH', 'Ghana', 'Ghana', '233', 'AF', 'Accra', 'GHS', 'en', '6', '15', '', ''),
         ('83', 'GI', 'Gibraltar', 'Gibraltar', '350', 'EU', 'Gibraltar', 'GIP', 'en', '6', '15', '', ''),
         ('84', 'GL', 'Greenland', 'Kalaallit Nunaat', '299', 'NA', 'Nuuk', 'DKK', 'kl', '6', '15', '', ''),
         ('85', 'GM', 'Gambia', 'Gambia', '220', 'AF', 'Banjul', 'GMD', 'en', '6', '15', '', ''),
         ('86', 'GN', 'Guinea', 'Guinée', '224', 'AF', 'Conakry', 'GNF', 'fr,ff', '6', '15', '', ''),
         ('87', 'GP', 'Guadeloupe', 'Guadeloupe', '590', 'NA', 'Basse-Terre', 'EUR', 'fr', '6', '15', '', ''),
         ('88', 'GQ', 'Equatorial Guinea', 'Guinea Ecuatorial', '240', 'AF', 'Malabo', 'XAF', 'es,fr',
          '6', '15', '', ''),
         ('89', 'GR', 'Greece', 'Ελλάδα', '30', 'EU', 'Athens', 'EUR', 'el', '6', '15', '', ''),
         ('90', 'GS', 'South Georgia and the South Sandwich Islands', 'South Georgia', '500', 'AN',
          'King Edward Point', 'GBP', 'en', '6', '15', '', ''),
         ('91', 'GT', 'Guatemala', 'Guatemala', '502', 'NA', 'Guatemala City', 'GTQ', 'es', '6', '15',
          '', ''),
         ('92', 'GU', 'Guam', 'Guam', '1671', 'OC', 'Hagåtña', 'USD', 'en,ch,es', '6', '15', '', ''),
         ('93', 'GW', 'Guinea-Bissau', 'Guiné-Bissau', '245', 'AF', 'Bissau', 'XOF', 'pt', '6', '15',
          '', ''),
         ('94', 'GY', 'Guyana', 'Guyana', '592', 'SA', 'Georgetown', 'GYD', 'en', '6', '15', '', ''),
         
         ('95', 'HK', 'Hong Kong', '香港', '852', 'AS', 'City of Victoria', 'HKD', 'zh,en', '6', '15', '', ''),
         ('96', 'HM', 'Heard Island and McDonald Islands', 'Heard Island and McDonald Islands', '',
          'AN', '', 'AUD', 'en', '6', '15', '', ''),
         ('97', 'HN', 'Honduras', 'Honduras', '504', 'NA', 'Tegucigalpa', 'HNL', 'es', '6', '15', '', ''),
         ('98', 'HR', 'Croatia', 'Hrvatska', '385', 'EU', 'Zagreb', 'HRK', 'hr', '6', '15', '', ''),
         ('99', 'HT', 'Haiti', 'Haïti', '509', 'NA', 'Port-au-Prince', 'HTG,USD', 'fr,ht', '6', '15', '', ''),
         ('100', 'HU', 'Hungary', 'Magyarország', '36', 'EU', 'Budapest', 'HUF', 'hu', '6', '15', '', ''),
         ('101', 'ID', 'Indonesia', 'Indonesia', '62', 'AS', 'Jakarta', 'IDR', 'id', '6', '15', '', ''),
         ('102', 'IE', 'Ireland', 'Éire', '353', 'EU', 'Dublin', 'EUR', 'ga,en', '6', '15', '', ''),
         ('103', 'IL', 'Israel', 'יִשְׂרָאֵל', '972', 'AS', 'Jerusalem', 'ILS', 'he,ar', '6', '15', '', ''),
         ('104', 'IM', 'Isle of Man', 'Isle of Man', '44', 'EU', 'Douglas', 'GBP', 'en,gv', '6', '15', '', ''),
         ('105', 'IN', 'India', 'भारत', '91', 'AS', 'New Delhi', 'INR', 'hi,en', '6', '15', '', ''),
         ('106', 'IO', 'British Indian Ocean Territory', 'British Indian Ocean Territory', '246', 'AS',
          'Diego Garcia', 'USD', 'en', '6', '15', '', ''),
         ('107', 'IQ', 'Iraq', 'العراق', '964', 'AS', 'Baghdad', 'IQD', 'ar,ku', '6', '15', '', ''),
         ('108', 'IR', 'Iran', 'Irān', '98', 'AS', 'Tehran', 'IRR', 'fa', '6', '15', '', ''),
         ('109', 'IS', 'Iceland', 'Ísland', '354', 'EU', 'Reykjavik', 'ISK', 'is', '6', '15', '', ''),
         ('110', 'IT', 'Italy', 'Italia', '39', 'EU', 'Rome', 'EUR', 'it', '6', '15', '', ''),
         ('111', 'JE', 'Jersey', 'Jersey', '44', 'EU', 'Saint Helier', 'GBP', 'en,fr', '6', '15', '', ''),
         ('112', 'JM', 'Jamaica', 'Jamaica', '1876', 'NA', 'Kingston', 'JMD', 'en', '6', '15', '', ''),
         ('113', 'JO', 'Jordan', 'الأردن', '962', 'AS', 'Amman', 'JOD', 'ar', '6', '15', '', ''),
         ('114', 'JP', 'Japan', '日本', '81', 'AS', 'Tokyo', 'JPY', 'ja', '6', '15', '', ''),
         ('115', 'KE', 'Kenya', 'Kenya', '254', 'AF', 'Nairobi', 'KES', 'en,sw', '6', '15', '', ''),
         ('116', 'KG', 'Kyrgyzstan', 'Кыргызстан', '996', 'AS', 'Bishkek', 'KGS', 'ky,ru', '6', '15', '', ''),
         ('117', 'KH', 'Cambodia', 'Kâmpŭchéa', '855', 'AS', 'Phnom Penh', 'KHR', 'km', '6', '15', '', ''),
         ('118', 'KI', 'Kiribati', 'Kiribati', '686', 'OC', 'South Tarawa', 'AUD', 'en', '6', '15', '', ''),
         ('119', 'KM', 'Comoros', 'Komori', '269', 'AF', 'Moroni', 'KMF', 'ar,fr', '6', '15', '', ''),
         ('120', 'KN', 'Saint Kitts and Nevis', 'Saint Kitts and Nevis', '1869', 'NA', 'Basseterre',
          'XCD', 'en', '6', '15', '', ''),
         ('121', 'KP', 'North Korea', '북한', '850', 'AS', 'Pyongyang', 'KPW', 'ko', '6', '15', '', ''),
         ('122', 'KR', 'South Korea', '대한민국', '82', 'AS', 'Seoul', 'KRW', 'ko', '6', '15', '', ''),
         ('123', 'KW', 'Kuwait', 'الكويت', '965', 'AS', 'Kuwait City', 'KWD', 'ar', '6', '15', '', ''),
         ('124', 'KY', 'Cayman Islands', 'Cayman Islands', '1345', 'NA', 'George Town', 'KYD', 'en', '6',
          '15', '', ''),
         ('125', 'KZ', 'Kazakhstan', 'Қазақстан', '76,77', 'AS', 'Astana', 'KZT', 'kk,ru', '6', '15', '', ''),
         ('126', 'LA', 'Laos', 'ສປປລາວ', '856', 'AS', 'Vientiane', 'LAK', 'lo', '6', '15', '', ''),
         ('127', 'LB', 'Lebanon', 'لبنان', '961', 'AS', 'Beirut', 'LBP', 'ar,fr', '6', '15', '', ''),
         ('128', 'LC', 'Saint Lucia', 'Saint Lucia', '1758', 'NA', 'Castries', 'XCD', 'en', '6', '15', '', ''),
         ('129', 'LI', 'Liechtenstein', 'Liechtenstein', '423', 'EU', 'Vaduz', 'CHF', 'de', '6', '15', '', ''),
         ('130', 'LK', 'Sri Lanka', 'śrī laṃkāva', '94', 'AS', 'Colombo', 'LKR', 'si,ta', '6', '15', '', ''),
         ('131', 'LR', 'Liberia', 'Liberia', '231', 'AF', 'Monrovia', 'LRD', 'en', '6', '15', '', ''),
         ('132', 'LS', 'Lesotho', 'Lesotho', '266', 'AF', 'Maseru', 'LSL,ZAR', 'en,st', '6', '15', '', ''),
         ('133', 'LT', 'Lithuania', 'Lietuva', '370', 'EU', 'Vilnius', 'LTL', 'lt', '6', '15',
          '', ''),
         ('134', 'LU', 'Luxembourg', 'Luxembourg', '352', 'EU', 'Luxembourg', 'EUR', 'fr,de,lb',
          '6', '15', '', ''),
         ('135', 'LV', 'Latvia', 'Latvija', '371', 'EU', 'Riga', 'EUR', 'lv', '6', '15', '', ''),
         ('136', 'LY', 'Libya', '‏ليبيا', '218', 'AF', 'Tripoli', 'LYD', 'ar', '6', '15', '', ''),
         ('137', 'MA', 'Morocco', 'المغرب', '212', 'AF', 'Rabat', 'MAD', 'ar', '6', '15', '', ''),
         ('138', 'MC', 'Monaco', 'Monaco', '377', 'EU', 'Monaco', 'EUR', 'fr', '6', '15', '', ''),
         ('139', 'MD', 'Moldova', 'Moldova', '373', 'EU', 'Chișinău', 'MDL', 'ro', '6', '15', '',
          ''),
         ('140', 'ME', 'Montenegro', 'Црна Гора', '382', 'EU', 'Podgorica', 'EUR', 'sr,bs,sq,hr',
          '6', '15', '', ''),
         ('141', 'MF', 'Saint Martin', 'Saint-Martin', '590', 'NA', 'Marigot', 'EUR', 'en,fr,nl',
          '6', '15', '', ''),
         ('142', 'MG', 'Madagascar', 'Madagasikara', '261', 'AF', 'Antananarivo', 'MGA', 'fr,mg',
          '6', '15', '', ''),
         ('143', 'MH', 'Marshall Islands', 'M̧ajeļ', '692', 'OC', 'Majuro', 'USD', 'en,mh', '6', '15', '', ''),
         ('144', 'MK', 'Macedonia', 'Македонија', '389', 'EU', 'Skopje', 'MKD', 'mk', '6', '15', '', ''),
         ('145', 'ML', 'Mali', 'Mali', '223', 'AF', 'Bamako', 'XOF', 'fr', '6', '15', '', ''),
         ('146', 'MM', 'Myanmar [Burma]', 'Myanma', '95', 'AS', 'Naypyidaw', 'MMK', 'my', '6', '15', '', ''),
         ('147', 'MN', 'Mongolia', 'Монгол улс', '976', 'AS', 'Ulan Bator', 'MNT', 'mn', '6', '15', '', ''),
         ('148', 'MO', 'Macao', '澳門', '853', 'AS', '', 'MOP', 'zh,pt', '6', '15', '', ''),
         ('149', 'MP', 'Northern Mariana Islands', 'Northern Mariana Islands', '1670', 'OC',
          'Saipan', 'USD', 'en,ch', '6', '15', '', ''),
         ('150', 'MQ', 'Martinique', 'Martinique', '596', 'NA', 'Fort-de-France', 'EUR', 'fr', '6', '15',
          '', ''),
         ('151', 'MR', 'Mauritania', 'موريتانيا', '222', 'AF', 'Nouakchott', 'MRO', 'ar', '6', '15', '', ''),
         ('152', 'MS', 'Montserrat', 'Montserrat', '1664', 'NA', 'Plymouth', 'XCD', 'en', '6', '15', '', ''),
         ('153', 'MT', 'Malta', 'Malta', '356', 'EU', 'Valletta', 'EUR', 'mt,en', '6', '15', '', ''),
         ('154', 'MU', 'Mauritius', 'Maurice', '230', 'AF', 'Port Louis', 'MUR', 'en', '6', '15', '', ''),
         ('155', 'MV', 'Maldives', 'Maldives', '960', 'AS', 'Malé', 'MVR', 'dv', '6', '15', '', ''),
         ('156', 'MW', 'Malawi', 'Malawi', '265', 'AF', 'Lilongwe', 'MWK', 'en,ny', '6', '15', '', ''),
         ('157', 'MX', 'Mexico', 'México', '52', 'NA', 'Mexico City', 'MXN', 'es', '6', '15', '', ''),
         ('158', 'MY', 'Malaysia', 'Malaysia', '60', 'AS', 'Kuala Lumpur', 'MYR', '', '6', '15', '', ''),
         ('159', 'MZ', 'Mozambique', 'Moçambique', '258', 'AF', 'Maputo', 'MZN', 'pt', '6', '15', '', ''),
         ('160', 'NA', 'Namibia', 'Namibia', '264', 'AF', 'Windhoek', 'NAD,ZAR', 'en,af', '6', '15', '', ''),
         ('161', 'NC', 'New Caledonia', 'Nouvelle-Calédonie', '687', 'OC', 'Nouméa', 'XPF', 'fr', '6',
          '15', '', ''),
         ('162', 'NE', 'Niger', 'Niger', '227', 'AF', 'Niamey', 'XOF', 'fr', '6', '15', '', ''),
         ('163', 'NF', 'Norfolk Island', 'Norfolk Island', '672', 'OC', 'Kingston', 'AUD', 'en', '6',
          '15', '', ''),
         ('164', 'NG', 'Nigeria', 'Nigeria', '234', 'AF', 'Abuja', 'NGN', 'en', '6', '15', '', ''),
         ('165', 'NI', 'Nicaragua', 'Nicaragua', '505', 'NA', 'Managua', 'NIO', 'es', '6', '15', '', ''),
         ('166', 'NL', 'Netherlands', 'Nederland', '31', 'EU', 'Amsterdam', 'EUR', 'nl', '6', '15', '', ''),
         ('167', 'NO', 'Norway', 'Norge', '47', 'EU', 'Oslo', 'NOK', 'no,nb,nn', '6', '15', '', ''),
         ('168', 'NP', 'Nepal', 'नपल', '977', 'AS', 'Kathmandu', 'NPR', 'ne', '6', '15', '', ''),
         ('169', 'NR', 'Nauru', 'Nauru', '674', 'OC', 'Yaren', 'AUD', 'en,na', '6', '15', '', ''),
         ('170', 'NU', 'Niue', 'Niuē', '683', 'OC', 'Alofi', 'NZD', 'en', '6', '15', '', ''),
         ('171', 'NZ', 'New Zealand', 'New Zealand', '64', 'OC', 'Wellington', 'NZD', 'en,mi', '6',
          '15', '', ''),
         ('172', 'OM', 'Oman', 'عمان', '968', 'AS', 'Muscat', 'OMR', 'ar', '6', '15', '', ''),
         ('173', 'PA', 'Panama', 'Panamá', '507', 'NA', 'Panama City', 'PAB,USD', 'es', '6', '15', '', ''),
         ('174', 'PE', 'Peru', 'Perú', '51', 'SA', 'Lima', 'PEN', 'es', '6', '15', '', ''),
         ('175', 'PF', 'French Polynesia', 'Polynésie française', '689', 'OC', 'Papeetē', 'XPF', 'fr', '6',
          '15', '', ''),
         ('176', 'PG', 'Papua New Guinea', 'Papua Niugini', '675', 'OC', 'Port Moresby', 'PGK', 'en', '6',
          '15', '', ''),
         ('177', 'PH', 'Philippines', 'Pilipinas', '63', 'AS', 'Manila', 'PHP', 'en', '6', '15', '', ''),
         ('178', 'PK', 'Pakistan', 'Pakistan', '92', 'AS', 'Islamabad', 'PKR', 'en,ur', '6', '15', '', ''),
         ('179', 'PL', 'Poland', 'Polska', '48', 'EU', 'Warsaw', 'PLN', 'pl', '6', '15', '', ''),
         ('180', 'PM', 'Saint Pierre and Miquelon', 'Saint-Pierre-et-Miquelon', '508', 'NA',
          'Saint-Pierre', 'EUR', 'fr', '6', '15', '', ''),
         ('181', 'PN', 'Pitcairn Islands', 'Pitcairn Islands', '64', 'OC', 'Adamstown', 'NZD', 'en', '6',
          '15', '', ''),
         ('182', 'PR', 'Puerto Rico', 'Puerto Rico', '1787,1939', 'NA', 'San Juan', 'USD', 'es,en', '6',
          '15', '', ''),
         ('183', 'PS', 'Palestine', 'فلسطين', '970', 'AS', 'Ramallah', 'ILS', 'ar', '6', '15', '', ''),
         ('184', 'PT', 'Portugal', 'Portugal', '351', 'EU', 'Lisbon', 'EUR', 'pt', '6', '15', '', ''),
         ('185', 'PW', 'Palau', 'Palau', '680', 'OC', 'Ngerulmud', 'USD', 'en', '6', '15', '', ''),
         ('186', 'PY', 'Paraguay', 'Paraguay', '595', 'SA', 'Asunción', 'PYG', 'es,gn', '6', '15', '', ''),
         ('187', 'QA', 'Qatar', 'قطر', '974', 'AS', 'Doha', 'QAR', 'ar', '6', '15', '', ''),
         ('188', 'RE', 'Réunion', 'La Réunion', '262', 'AF', 'Saint-Denis', 'EUR', 'fr', '6', '15', '', ''),
         ('189', 'RO', 'Romania', 'România', '40', 'EU', 'Bucharest', 'RON', 'ro', '6', '15', '', ''),
         ('190', 'RS', 'Serbia', 'Србија', '381', 'EU', 'Belgrade', 'RSD', 'sr', '6', '15', '', ''),
         ('191', 'RU', 'Russia', 'Россия', '7', 'EU', 'Moscow', 'RUB', 'ru', '6', '15', '', ''),
         ('192', 'RW', 'Rwanda', 'Rwanda', '250', 'AF', 'Kigali', 'RWF', 'rw,en,fr', '6', '15', '', ''),
         ('193', 'SA', 'Saudi Arabia', 'العربية السعودية', '966', 'AS', 'Riyadh', 'SAR', 'ar', '6',
          '15', '', ''),
         ('194', 'SB', 'Solomon Islands', 'Solomon Islands', '677', 'OC', 'Honiara', 'SDB', 'en', '6',
          '15', '', ''),
         ('195', 'SC', 'Seychelles', 'Seychelles', '248', 'AF', 'Victoria', 'SCR', 'fr,en', '6', '15',
          '', ''),
         ('196', 'SD', 'Sudan', 'السودان', '249', 'AF', 'Khartoum', 'SDG', 'ar,en', '6', '15', '', ''),
         ('197', 'SE', 'Sweden', 'Sverige', '46', 'EU', 'Stockholm', 'SEK', 'sv', '6', '15', '', ''),
         ('198', 'SG', 'Singapore', 'Singapore', '65', 'AS', 'Singapore', 'SGD', 'en,ms,ta,zh', '6',
          '15', '', ''),
         ('199', 'SH', 'Saint Helena', 'Saint Helena', '290', 'AF', 'Jamestown', 'SHP', 'en', '6', '15',
          '', ''),
         ('200', 'SI', 'Slovenia', 'Slovenija', '386', 'EU', 'Ljubljana', 'EUR', 'sl', '6', '15', '', ''),
         ('201', 'SJ', 'Svalbard and Jan Mayen', 'Svalbard og Jan Mayen', '4779', 'EU', 'Longyearbyen',
          'NOK', 'no', '6', '15', '', ''),
         ('202', 'SK', 'Slovakia', 'Slovensko', '421', 'EU', 'Bratislava', 'EUR', 'sk', '6', '15', '', ''),
         ('203', 'SL', 'Sierra Leone', 'Sierra Leone', '232', 'AF', 'Freetown', 'SLL', 'en', '6', '15', '',
          ''),
         ('204', 'SM', 'San Marino', 'San Marino', '378', 'EU', 'City of San Marino', 'EUR', 'it', '6', '15',
          '', ''),
         ('205', 'SN', 'Senegal', 'Sénégal', '221', 'AF', 'Dakar', 'XOF', 'fr', '6', '15', '', ''),
         ('206', 'SO', 'Somalia', 'Soomaaliya', '252', 'AF', 'Mogadishu', 'SOS', 'so,ar', '6', '15', '', ''),
         ('207', 'SR', 'Suriname', 'Suriname', '597', 'SA', 'Paramaribo', 'SRD', 'nl', '6', '15', '', ''),
         ('208', 'SS', 'South Sudan', 'South Sudan', '211', 'AF', 'Juba', 'SSP', 'en', '6', '15', '', ''),
         ('209', 'ST', 'São Tomé and Príncipe', 'São Tomé e Príncipe', '239', 'AF', 'São Tomé', 'STD',
          'pt', '6', '15', '', ''),
         ('210', 'SV', 'El Salvador', 'El Salvador', '503', 'NA', 'San Salvador', 'SVC,USD', 'es', '6',
          '15', '', ''),
         ('211', 'SX', 'Sint Maarten', 'Sint Maarten', '1721', 'NA', 'Philipsburg', 'ANG', 'nl,en', '6',
          '15', '', ''),
         ('212', 'SY', 'Syria', 'سوريا', '963', 'AS', 'Damascus', 'SYP', 'ar', '6', '15', '', ''),
         ('213', 'SZ', 'Swaziland', 'Swaziland', '268', 'AF', 'Lobamba', 'SZL', 'en,ss', '6', '15', '', ''),
         ('214', 'TC', 'Turks and Caicos Islands', 'Turks and Caicos Islands', '1649', 'NA',
          'Cockburn Town', 'USD', 'en', '6', '15', '', ''),
         ('215', 'TD', 'Chad', 'Tchad', '235', 'AF', 'N''Djamena', 'XAF', 'fr,ar', '6', '15', '', ''),
         ('216', 'TF', 'French Southern Territories', 'Territoire des Terres australes et antarctiques fr',
          '', 'AN', 'Port-aux-Français', 'EUR', 'fr', '6', '15', '', ''),
         ('217', 'TG', 'Togo', 'Togo', '228', 'AF', 'Lomé', 'XOF', 'fr', '6', '15', '', ''),
         ('218', 'TH', 'Thailand',
          'ประเทศไทย',
           '66', 'AS', 'Bangkok', 'THB', 'th', '6', '15', '', ''),
         ('219', 'TJ', 'Tajikistan', 'Тоҷикистон', '992', 'AS', 'Dushanbe', 'TJS', 'tg,ru', '6', '15', '',
          ''),
         ('220', 'TK', 'Tokelau', 'Tokelau', '690', 'OC', 'Fakaofo', 'NZD', 'en', '6', '15', '', ''),
         ('221', 'TL', 'East Timor', 'Timor-Leste', '670', 'OC', 'Dili', 'USD', 'pt', '6', '15', '', ''),
         ('222', 'TM', 'Turkmenistan', 'Türkmenistan', '993', 'AS', 'Ashgabat', 'TMT', 'tk,ru', '6', '15',
          '', ''),
         ('223', 'TN', 'Tunisia', 'تونس', '216', 'AF', 'Tunis', 'TND', 'ar', '6', '15', '', ''),
         ('224', 'TO', 'Tonga', 'Tonga', '676', 'OC', 'Nuku''alofa', 'TOP', 'en,to', '6', '15', '', ''),
         ('225', 'TR', 'Turkey', 'Türkiye', '90', 'AS', 'Ankara', 'TRY', 'tr', '6', '15', '', ''),
         ('226', 'TT', 'Trinidad and Tobago', 'Trinidad and Tobago', '1868', 'NA', 'Port of Spain', 'TTD',
          'en', '6', '15', '', ''),
         ('227', 'TV', 'Tuvalu', 'Tuvalu', '688', 'OC', 'Funafuti', 'AUD', 'en', '6', '15', '', ''),
         ('228', 'TW', 'Taiwan', '臺灣', '886', 'AS', 'Taipei', 'TWD', 'zh', '6', '15', '', ''),
         ('229', 'TZ', 'Tanzania', 'Tanzania', '255', 'AF', 'Dodoma', 'TZS', 'sw,en', '6', '15', '', ''),
         ('230', 'UA', 'Ukraine', 'Україна', '380', 'EU', 'Kiev', 'UAH', 'uk', '6', '15', '', ''),
         ('231', 'UG', 'Uganda', 'Uganda', '256', 'AF', 'Kampala', 'UGX', 'en,sw', '6', '15', '', ''),
         ('232', 'UM', 'U.S. Minor Outlying Islands', 'United States Minor Outlying Islands', '', 'OC',
          '', 'USD', 'en', '6', '15', '', ''),
         ('233', 'US', 'United States', 'United States', '1', 'NA', 'Washington D.C.', 'USD,USN,USS',
          'en', '6', '15', '', ''),
         ('234', 'UY', 'Uruguay', 'Uruguay', '598', 'SA', 'Montevideo', 'UYI,UYU', 'es', '6', '15', '',
          ''),
         ('235', 'UZ', 'Uzbekistan', 'O‘zbekiston', '998', 'AS', 'Tashkent', 'UZS', 'uz,ru', '6', '15',
          '', ''),
         ('236', 'VA', 'Vatican City', 'Vaticano', '39066,379', 'EU', 'Vatican City', 'EUR', 'it,la',
          '6', '15', '', ''),
         ('237', 'VC', 'Saint Vincent and the Grenadines', 'Saint Vincent and the Grenadines', '1784',
          'NA', 'Kingstown', 'XCD', 'en', '6', '15', '', ''),
         ('238', 'VE', 'Venezuela', 'Venezuela', '58', 'SA', 'Caracas', 'VEF', 'es', '6', '15', '', ''),
         ('239', 'VG', 'British Virgin Islands', 'British Virgin Islands', '1284', 'NA', 'Road Town',
          'USD', 'en', '6', '15', '', ''),
         ('240', 'VI', 'U.S. Virgin Islands', 'United States Virgin Islands', '1340', 'NA',
          'Charlotte Amalie', 'USD', 'en', '6', '15', '', ''),
         ('241', 'VN', 'Vietnam', 'Việt Nam', '84', 'AS', 'Hanoi', 'VND', 'vi', '6', '15', '', ''),
         ('242', 'VU', 'Vanuatu', 'Vanuatu', '678', 'OC', 'Port Vila', 'VUV', 'bi,en,fr', '6', '15', '', ''),
         ('243', 'WF', 'Wallis and Futuna', 'Wallis et Futuna', '681', 'OC', 'Mata-Utu', 'XPF', 'fr', '6',
          '15', '', ''),
         ('244', 'WS', 'Samoa', 'Samoa', '685', 'OC', 'Apia', 'WST', 'sm,en', '6', '15', '', ''),
         ('245', 'XK', 'Kosovo', 'Republika e Kosovës', '377,381,386', 'EU', 'Pristina', 'EUR', 'sq,sr',
          '6', '15', '', ''),
         ('246', 'YE', 'Yemen', 'اليَمَن', '967', 'AS', 'Sana''a', 'YER', 'ar', '6', '15', '', ''),
         ('247', 'YT', 'Mayotte', 'Mayotte', '262', 'AF', 'Mamoudzou', 'EUR', 'fr', '6', '15', '', ''),
         ('248', 'ZA', 'South Africa', 'South Africa', '27', 'AF', 'Pretoria', 'ZAR', 
         'af,en,nr,st,ss,tn,ts,ve,xh,zu', '6', '15', '', ''),
         ('249', 'ZM', 'Zambia', 'Zambia', '260', 'AF', 'Lusaka', 'ZMK', 'en', '6', '15', '', ''),
         ('250', 'ZW', 'Zimbabwe', 'Zimbabwe', '263', 'AF', 'Harare', 'ZWL', 'en,sn,nd', '6', '15', '', '');
        ");
        }
    }

    public function notificationsSQL()
    {
        // Notifications
        $ordersSQL  = "";
        $msgSQL     = "";

        $orderStates = OrderState::getOrderStates((int)Configuration::get('PS_LANG_DEFAULT'));

        // creamos notificaciones para customers
        foreach ($orderStates as $order) {
            // customer actionOrderStatusPostUpdate
            $ordersSQL .= "('customer','actionOrderStatusPostUpdate', ".$order['id_order_state'].", 0),";
        }

        // nuevo pedido
        $ordersSQL .= "('customer','actionValidateOrder', null, 0),";

        // pago confirmado
        $ordersSQL .= "('customer','actionPaymentConfirmation', null, 0),";

        // devolución pedido
        $ordersSQL .= "('customer','actionOrderReturn', null, 0),";


        // creamos notificaciones para admin
        foreach ($orderStates as $order) {
            // customer actionOrderStatusPostUpdate
            $ordersSQL .= "('admin','actionOrderStatusPostUpdate', ".$order['id_order_state'].", 0),";
        }

        // nuevo pedido
        $ordersSQL .= "('admin','actionValidateOrder', null, 0),";

        // pago confirmado
        $ordersSQL .= "('admin','actionPaymentConfirmation', null, 0),";

        // devolución pedido
        $ordersSQL .= "('admin','actionOrderReturn', null, 0),";

        // Nueva cuenta
        $ordersSQL .= "('admin','actionCustomerAccountAdd', null, 0),";

        // Productos
        //$ordersSQL .= "('admin','actionProductOutOfStock', null, 0),";
        $ordersSQL .= "('admin','actionProductDelete', null, 0),";

        $ordersSQL = trim($ordersSQL, ',');

        if (!Db::getInstance()->ExecuteS("SELECT * FROM " . _DB_PREFIX_ . "mensagia_sms_notifications")) {
            Db::getInstance()->Execute("INSERT INTO " . _DB_PREFIX_ . "mensagia_sms_notifications 
             (`type`, `hook`, `option_id`, `active`) VALUES " . $ordersSQL.";");
        }

        // Prepare orders
        $orderStates = MensagiaSMSNotification::getAllOrderStates();
        $orderArray  = array();

        if ($orderStates) {
            foreach ($orderStates as $order) {
                $orderArray[$order['id_order_state']."_".$order['id_lang']] = $order['name'];
            }
        }

        // ESTADOS DEL PEDIDO

        $default_states_msg_customer = array(
            'es' => "Estimado/a {customer_firstname}, el estado de su pedido [{order_reference}] ha cambiado a: ",
            'ca' => "Benvolgut/da {customer_firstname}, l\\'estat de la seva comanda [{order_reference}] ".
            "ha canviat a: ",
            'gl' => "Estimado {customer_firstname}, o estado do seu pedido [{order_reference}] cambiou a: ",
            'eu' => "Kaixo {customer_firstname}, zure eskaera [{order_reference}] estatusa aldatu: ",
            'en' => "Dear {customer_firstname}, the status of your order [{order_reference}] has been changed to: ",
            'fr' => "Cher client {firstname}, l\\'état de votre commande [{order_reference}] changé: ",
            'de' => "Lieber {customer_firstname}, der Status Ihrer Bestellung [{order_reference}] geändert: ",
            'it' => "Caro {customer_firstname}, lo stato del tuo nuovo ordine [{order_reference}] è cambiato in:",
        );

        $default_states_msg_admin = array(
            'es' => "{shop_name}: El estado del pedido [{order_reference}] ha cambiado a: ",
            'ca' => "{shop_name}: L\\'estat de la comanda [{order_reference}] ha canviat a: ",
            'gl' => "{shop_name}: O estado da solicitude [{order_reference}] cambiou a: ",
            'eu' => "{shop_name}: Ordena estatusa [{order_reference}] duela ezarri da: ",
            'en' => "{shop_name}: Order status [{order_reference}] changed to: ",
            'fr' => "{shop_name}: L\\'état de la commande [{order_reference}] a changé: ",
            'de' => "{shop_name}: Der Auftragsstatus [{order_reference}] hat sich geändert: ",
            'it' => "{shop_name}: Lo stato dell'ordine [{ordine_reference}] è stato modificato in: ",
        );


        // NUEVO PEDIDO

        $default_neworder_msg_customer = array(
            'es' => "Su nuevo pedido [{order_reference}] ha sido creado correctamente. ".
            "Modo de pago: {order_payment}. Importe: {order_total_paid}{order_currency}",
            'ca' => "La seva comanda [{order_reference}] s\\'ha creat correctament. ".
            "Metode de pagament: {order_payment}. Import: {order_total_paid}{order_currency}",
            'gl' => "A súa nova orde [{order_reference}] foi creado correctamente.".
            "Modo pagamento: {order_payment}. Cantidade: {order_total_paid}{order_currency}",
            'eu' => "Zure eskaera berririk [{order_reference}] ek sortu du correctamente. ".
            "Modo ordainketa: {order_payment}. Zenbatekoa: {order_total_paid}{order_currency}",
            'en' => "Your new order [{order_reference}] was created successfully. ".
            "Payment method: {order_payment}. Amount: {order_total_paid} {order_currency}",
            'fr' => "Votre nouvelle commande [{order_reference}] a été créée avec succès. ".
            "Mode de paiement : {order_payment}. Montant : {order_total_paid}{order_currency}",
            'de' => "Ihre neue Bestellung [{order_reference}] wurde erfolgreich erstellt. ".
            "Zahlungsweise: {order_payment}. Betrag: {order_total_paid}{order_currency}",
            'it' => "Il tuo nuovo ordine [{order_reference}] è stato creato con successo. ".
            "Modalità di pagamento: {order_payment}. Importo: {order_total_paid}{order_currency}",
        );

        $default_neworder_msg_admin = array(
            'es' => "Nuevo pedido con id [{order_reference}] del cliente {customer_id}. ".
            "Modo de pago: {order_payment}. Importe: {order_total_paid}{order_currency}",
            'ca' => "Nova comanda amb id [{order_reference}] del cliente {customer_id}. ".
            "Metode de pagament: {order_payment}. Import: {order_total_paid}{order_currency}",
            'gl' => "Nova orde con id [{order_reference}] cliente {customer_id}. ".
            "Pagamento: {order_payment}. Cantidade: {order_total_paid}{order_currency}",
            'eu' => "euNuevo pedido con id [{order_reference}] del cliente {customer_id}. ".
            "Modo ordainketa: {order_payment}. Zenbatekoa: {order_total_paid}{order_currency}",
            'en' => "New order with id [{order_reference}] from customer {customer_id}. ".
            "Payment method: {order_payment}. Amount: {order_total_paid}{order_currency}",
            'fr' => "Nouvelle commande avec id {order_id} du client {customer_id}. ".
            "Mode de paiement : {order_payment}. Montant : {order_total_paid}{order_currency}",
            'de' => "Neue Bestellung mit ID {order_id} des Kunden {customer_id}. ".
            "Zahlungsweise: {order_payment}. Betrag: {order_total_paid}{order_currency}",
            'it' => "Nuovo ordine con id {order_id} del cliente {customer_id}. ".
            "Modalità di pagamento: {order_payment}. Importo: {order_total_paid}{order_currency}",
        );


        // PAGO CONFIRMADO

        $default_pago_conf_msg_customer = array(
            'es' => "Se ha confirmado el pago de su pedido [{order_reference}]. ".
             "Importe: {order_total_paid}{order_currency}",
            'ca' => "S\\'ha confirmat el pagament de la seva comanda [{order_reference}]. ".
             "Import: {order_total_paid}{order_currency}",
            'gl' => "Confirmou o pago da súa solicitude [{order_reference}]. ".
             "Pagamento: {order_total_paid}{order_currency}",
            'eu' => "Zure eskaera ordainketa berretsi egin da [{order_reference}]. ".
             "Zenbatekoa: {order_total_paid}{order_currency}",
            'en' => "Payment for your order [{order_reference}] has been confirmed.".
            "Amount: {order_total_paid}{order_currency}",
            'fr' => "Le paiement de votre commande {order_reference} a été reçu correctement. ".
             "Montant : {order_total_paid}{order_currency}",
            'de' => "Die Bezahlung der Bestellung {order_reference} wurde korrekt entgegengenommen. ".
             "Betrag: {order_total_paid}{order_currency}",
            'it' => "Il pagamento del tuo ordine {order_id} è stato ricevuto correttamente. ".
             "Importo: {order_total_paid}{order_currency}",
        );

        $default_pago_conf_msg_admin = array(
            'es' => "Se ha confirmado el pago del pedido [{order_reference}]. ".
             "Modo de pago: {order_payment} Importe: {order_total_paid}{order_currency}",
            'ca' => "S\\'ha confirmat el pagament de la comanda [{order_reference}]. ".
             "Metode de pagament: {order_payment} Import: {order_total_paid}{order_currency}",
            'gl' => "Confirmou a orde de pagamento [{order_reference}]. ".
             "Pagamento: {order_payment} Cantidade: {order_total_paid}{order_currency}",
            'eu' => "Baieztatu du ordainketa ordena [{order_reference}]. ".
             "Ordainketa: {order_payment} Zenbatekoa: {order_total_paid}{order_currency}",
            'en' => "Order payment [{order_reference}] has been confirmed. ".
             "Payment method: {order_payment} Amount: {order_total_paid}{order_currency}",
            'fr' => "Le paiement de la commande a été confirmé {order_id}. ".
             "Mode de paiement : {order_payment} Montant : {order_total_paid}{order_currency}",
            'de' => "Die Bezahlung der Bestellung {order_id} wurde bestätigt. ".
             "Zahlungsweise: {order_payment} Betrag: {order_total_paid}{order_currency}",
            'it' => "È stato confermato il pagamento dell\\'ordine {order_id}. ".
             "Modalità di pagamento: {order_payment} Importo: {order_total_paid}{order_currency}",
        );

        // DEVOLUCIÓN DE PEDIDO

        $default_devolucion_customer = array(
            'es' => "Hemos recibido su solicitud de devolución del pedido [{order_reference}]. ".
             "Su solicitud será procesada en el menor tiempo posible. Gracias.",
            'ca' => "Hem rebut la seva sol.licitud de devolució de la comanda [{order_reference}]. ".
             "La seva sol.licitud será procesada en el menor temps possible. Gracies.",
            'gl' => "Recibimos a túa solicitude de reembolso Order [{order_reference}]. ".
             "Súa solicitude será procesado o máis rápido posible. Grazas.",
            'eu' => "Zure itzultzea eskaera Agindua jaso dugu [{order_reference}]. ".
             "Zure eskaera prozesatu egingo da ahalik eta azkar. Eskerrik asko.",
            'en' => "We have received your order return order [{order_reference}]. ".
             "Your request will be processed in the shortest possible time. Thank you.",
            'fr' => "Nous avons reçu votre demande de retour de la commande {order_id}. ".
             "Votre demande sera traitée dans les plus brefs délais. Merci.",
            'de' => "Wir haben Ihren Antrag auf Rückgabe der Bestellung {order_id} erhalten. ".
             "Ihre Anfrage wird so schnell wie möglich bearbeitet. Vielen Dank.",
            'it' => "Abbiamo ricevuto la tua richiesta di restituzione dell\\'ordine {order_id}. ".
             "La tua richiesta verrà gestita nel minor tempo possibile. Grazie.",
        );

        $default_devolucion_admin = array(
             'es' => "El cliente {customer_id} ha solicitado la devolución del pedido [{order_reference}]. ".
              "Motivo del cliente: {customer_question}.",
             'ca' => "El client {customer_id} ha sol.licitat la devolució de la comanda [{order_reference}]. ".
              "Motiu del client: {customer_question}.",
             'gl' => "O cliente {customer_id} solicitou o regreso da orde [{order_reference}]. ".
              "Cliente Motivo: {customer_question}.",
             'eu' => "Bezero {CUSTOMER_ID} ordena itzulera eskatu du [{order_reference}]. ".
              "Arrazoia bezero: {customer_question}.",
             'en' => "Customer {customer_id} requested to return order [{order_reference}]. ".
              "Customer reason: {customer_question}.",
             'fr' => "Le client {customer_id} a demandé le retour de la commande {order_reference}. ".
              "Raison du client : {customer_question}",
             'de' => "Der Kunde {customer_id} hat die Rückgabe der Bestellung {order_reference} beantragt. ".
              "Motiv des Kunden: {customer_question}",
             'it' => "Il cliente {customer_id} ha richiesto la restituzione dell\\'ordine {order_id}. ".
              "Motivo del cliente: {customer_question}",
         );

         // NUEVA CUENTA

        $default_new_cust_account_customer = array(
            'es' => "Bienvenid@ a {shop_name}. Su cuenta se ha creado correctamente.",
            'ca' => "Benvingut/da a {shop_name}. La seva compte s\\'ha creat correctament.",
            'gl' => "glBienvenid@ a {shop_name}. Su cuenta se ha creado correctamente.",
            'eu' => "euBienvenid@ a {shop_name}. Su cuenta se ha creado correctamente.",
            'en' => "enBienvenid@ a {shop_name}. Su cuenta se ha creado correctamente.",
            'fr' => "frBienvenid@ a {shop_name}. Su cuenta se ha creado correctamente.",
            'de' => "deBienvenid@ a {shop_name}. Su cuenta se ha creado correctamente.",
            'it' => "itBienvenid@ a {shop_name}. Su cuenta se ha creado correctamente.",
        );

        $default_new_cust_account_admin = array(
            'es' => "Se ha creado una nueva cuenta en {shop_name}. Cliente: {customer_firstname} ".
            "{customer_lastname}. Email: {customer_email}. Id: {customer_id}.",
            'ca' => "S\\'ha creat una nova compte a {shop_name}. Client: {customer_firstname} ".
            "{customer_lastname}. Email: {customer_email}. Id: {customer_id}.",
            'gl' => "Creou unha nova conta en {shop_name}. Cliente: {customer_firstname} ".
            "{customer_lastname}. Email: {customer_email}. Id: {customer_id}.",
            'eu' => "Kontu berri bat sortu du {shop_name}. Bezero: {customer_firstname} ".
            "{customer_lastname}. Email: {customer_email}. Id: {customer_id}.",
            'en' => "A new account has been created in {shop_name}. Customer: {customer_firstname} ".
            "{customer_lastname}. Email: {customer_email}. Id: {customer_id}.",
            'fr' => "Un nouveau compte a été créé sur {shop_name}. Client : {customer_firstname} ".
            "{customer_lastname}. E-mail : {customer_email}. Id : {customer_id}.",
            'de' => "Es wurde ein neues Konto in {shop_name} eingerichtet. Kunde: {customer_firstname} ".
            "{customer_lastname}. E-Mail: {customer_email}. ID: {customer_id}.",
            'it' => "È stato creato un nuovo account su {shop_name}. Cliente: {customer_firstname} ".
            "{customer_lastname}. Email: {customer_email}. Id: {customer_id}.",
        );

        // PRODUCTOS ADMIN

        $default_out_of_stock_admin = array(
            'es' => "El producto {product_name} está fuera de stock. Ref: {product_ref}. ".
             "Cantidad: {product_quantity}.",
            'ca' => "El producte {product_name} está fora de stock. Ref: {product_ref}. ".
             "Quantitat: {product_quantity}.",
            'gl' => "{product_name} está fóra de stock. Ref: {product_ref}. ".
             "Cantidade: {product_quantity}.",
            'eu' => "{product_name} agortuta dago. Ref: {product_ref}. ".
             "Kopurua: {product_quantity}.",
            'en' => "Product {product_name} is out of stock. Ref: {product_ref}. ".
             "Quantity: {product_quantity}.",
            'fr' => "{product_name} est en rupture de stock. Ref: {product_ref}. ".
             "Quantité: {product_quantity}.",
            'de' => "{product_name} ist ausverkauft. Ref: {product_ref}. ".
             "Menge: {product_quantity}.",
        );

        $default_product_deleted_admin = array(
            'es' => "El producto {product_name} con id: {product_id} y ref: {product_ref} ha sido eliminado ".
            "por el usuario {employee_id} con email {employee_email}.",
            'ca' => "El producte {product_name} amb id: {product_id} i ref: {product_ref} s\\'ha eliminat ".
            "per l\\'usuari {employee_id} amb email {employee_email}.",
            'gl' => "O produto {product_name} id: {product_id} e ref: {product_ref} foi eliminado polo usuario ".
            "{employee_id}  email {employee_email}.",
            'eu' => "Produktuaren {product_name}, id: {product_id} eta ref: {product_ref} kendu egin da ".
            "erabiltzaile {employee_id} elektronikoarekin {employee_email}.",
            'en' => "The product {product_name} with id: {product_id} and ref: {product_ref} has been deleted ".
            "by user {employee_id} with email {employee_email}.",
            'fr' => "Le produit {product_name} avec id : {product_id} et réf : {product_ref} a été éliminé ".
            "par l\\'utilisateur {employee_id} avec e-mail {employee_email}.",
            'de' => "Das Produkt {product_name} mit ID: {product_id} und Ref.: {product_ref} wurde vom Benutzer ".
            "{employee_id} mit der E-Mail-Adresse {employee_email} gelöscht.",
            'it' => "Il prodotto {product_name} con id: {product_id} e n° di riferimento: {product_ref} è stato ".
            "eliminato dall\\'utente {employee_id} con email {employee_email}.",
        );


        $notifications_customer = MensagiaSMSNotification::getNotifications('customer');
        $notifications_admin    = MensagiaSMSNotification::getNotifications('admin');
        $languages              = Language::getLanguages(true, $this->context->shop->id);
        $default_lang_id        = (int)Configuration::get('PS_LANG_DEFAULT');
        $default_lang           = Language::getLanguage($default_lang_id);

        // de clientes en todos los idiomas
        foreach ($notifications_customer as $notification) {
            foreach ($languages as $lang) {
                switch ($notification['hook']) {
                    case 'actionOrderStatusPostUpdate':
                        if (isset($default_states_msg_customer[$lang['iso_code']])) {
                            // falta caso si no existe el idioma poner uno por defecto
                            $msg = $default_states_msg_customer[$lang['iso_code']].
                                $orderArray[$notification['option_id']."_".$lang['id_lang']];
                            $msgSQL .= "( ".$notification['id'].", ".$lang['id_lang'].", '".$msg."'),";
                        } else {
                            $msg = $default_states_msg_customer['en'].$orderArray[$notification['option_id']."_1"];
                            $msgSQL .= "( ".$notification['id'].", ".$lang['id_lang'].", '".$msg."'),";
                        }

                        break;

                    case 'actionValidateOrder':
                        if (isset($default_neworder_msg_customer[$lang['iso_code']])) {
                            // falta caso si no existe el idioma poner uno por defecto
                            $msg = $default_neworder_msg_customer[$lang['iso_code']];
                            $msgSQL .= "( ".$notification['id'].", ".$lang['id_lang'].", '".$msg."'),";
                        } else {
                            $msg = $default_neworder_msg_customer['en'];
                            $msgSQL .= "( ".$notification['id'].", ".$lang['id_lang'].", '".$msg."'),";
                        }

                        break;

                    case 'actionPaymentConfirmation':
                        if (isset($default_pago_conf_msg_customer[$lang['iso_code']])) {
                            // falta caso si no existe el idioma poner uno por defecto
                            $msg = $default_pago_conf_msg_customer[$lang['iso_code']];
                            $msgSQL .= "( ".$notification['id'].", ".$lang['id_lang'].", '".$msg."'),";
                        } else {
                            $msg = $default_pago_conf_msg_customer['en'];
                            $msgSQL .= "( ".$notification['id'].", ".$lang['id_lang'].", '".$msg."'),";
                        }

                        break;

                    case 'actionOrderReturn':
                        if (isset($default_devolucion_customer[$lang['iso_code']])) {
                            // falta caso si no existe el idioma poner uno por defecto
                            $msg = $default_devolucion_customer[$lang['iso_code']];
                            $msgSQL .= "( ".$notification['id'].", ".$lang['id_lang'].", '".$msg."'),";
                        } else {
                            $msg = $default_devolucion_customer['en'];
                            $msgSQL .= "( ".$notification['id'].", ".$lang['id_lang'].", '".$msg."'),";
                        }

                        break;

                    case 'actionCustomerAccountAdd':
                        if (isset($default_new_cust_account_customer[$lang['iso_code']])) {
                            // falta caso si no existe el idioma poner uno por defecto
                            $msg = $default_new_cust_account_customer[$lang['iso_code']];
                            $msgSQL .= "( ".$notification['id'].", ".$lang['id_lang'].", '".$msg."'),";
                        } else {
                            $msg = $default_new_cust_account_customer['en'];
                            $msgSQL .= "( ".$notification['id'].", ".$lang['id_lang'].", '".$msg."'),";
                        }

                        break;
                }
            }
        }

        // de administradores con un solo idioma
        foreach ($notifications_admin as $notification) {
            switch ($notification['hook']) {
                case 'actionOrderStatusPostUpdate':
                    if (isset($default_states_msg_admin[$default_lang['iso_code']])) {
                        $msg = $default_states_msg_admin[$default_lang['iso_code']].
                            $orderArray[$notification['option_id']."_".$default_lang['id_lang']];
                        $msgSQL .= "( ".$notification['id'].", 0, '".$msg."'),";
                    } else {
                        $msg = $default_states_msg_admin['en'].$orderArray[$notification['option_id']."_1"];
                        $msgSQL .= "( ".$notification['id'].", 0, '".$msg."'),";
                    }

                    break;


                case 'actionValidateOrder':
                    if (isset($default_neworder_msg_admin[$default_lang['iso_code']])) {
                        $msg = $default_neworder_msg_admin[$default_lang['iso_code']];
                        $msgSQL .= "( ".$notification['id'].", 0, '".$msg."'),";
                    } else {
                        $msg = $default_neworder_msg_admin['en'];
                        $msgSQL .= "( ".$notification['id'].", 0, '".$msg."'),";
                    }

                    break;

                case 'actionPaymentConfirmation':
                    if (isset($default_pago_conf_msg_admin[$default_lang['iso_code']])) {
                        $msg = $default_pago_conf_msg_admin[$default_lang['iso_code']];
                        $msgSQL .= "( ".$notification['id'].", 0, '".$msg."'),";
                    } else {
                        $msg = $default_pago_conf_msg_admin['en'];
                        $msgSQL .= "( ".$notification['id'].", 0, '".$msg."'),";
                    }

                    break;

                case 'actionOrderReturn':
                    if (isset($default_devolucion_admin[$default_lang['iso_code']])) {
                        $msg = $default_devolucion_admin[$default_lang['iso_code']];
                        $msgSQL .= "( ".$notification['id'].", 0, '".$msg."'),";
                    } else {
                        $msg = $default_devolucion_admin['en'];
                        $msgSQL .= "( ".$notification['id'].", 0, '".$msg."'),";
                    }
                    break;

                case 'actionCustomerAccountAdd':
                    if (isset($default_new_cust_account_admin[$default_lang['iso_code']])) {
                        $msg = $default_new_cust_account_admin[$default_lang['iso_code']];
                        $msgSQL .= "( ".$notification['id'].", 0, '".$msg."'),";
                    } else {
                        $msg = $default_new_cust_account_admin['en'];
                        $msgSQL .= "( ".$notification['id'].", 0, '".$msg."'),";
                    }
                    break;

                case 'actionProductOutOfStock':
                    if (isset($default_out_of_stock_admin[$default_lang['iso_code']])) {
                        $msg = $default_out_of_stock_admin[$default_lang['iso_code']];
                        $msgSQL .= "( ".$notification['id'].", 0, '".$msg."'),";
                    } else {
                        $msg = $default_out_of_stock_admin['en'];
                        $msgSQL .= "( ".$notification['id'].", 0, '".$msg."'),";
                    }

                    break;

                case 'actionProductDelete':
                    if (isset($default_product_deleted_admin[$default_lang['iso_code']])) {
                        $msg = $default_product_deleted_admin[$default_lang['iso_code']];
                        $msgSQL .= "( ".$notification['id'].", 0, '".$msg."'),";
                    } else {
                        $msg = $default_product_deleted_admin['en'];
                        $msgSQL .= "( ".$notification['id'].", 0, '".$msg."'),";
                    }

                    break;
            }
        }

        $msgSQL = trim($msgSQL, ',');

        if (!Db::getInstance()->ExecuteS("SELECT * FROM " . _DB_PREFIX_ . "mensagia_sms_notifications_lang")) {
            Db::getInstance()->Execute("INSERT INTO " . _DB_PREFIX_ . "mensagia_sms_notifications_lang 
            ( `mensagia_sms_notification_id`, `lang_id`, `message`) VALUES " . $msgSQL.";");
        }
    }
}
